/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Comment;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AddCommentRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add-comment";
    public static final AddCommentRequestHandler INSTANCE = new AddCommentRequestHandler();
    private static final SimpleAttributeDefinition COMMENTTEXT = new SimpleAttributeDefinitionBuilder("comment-text", ModelType.STRING).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add-comment", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(AddCommentRequestHandler.getParameters(new AttributeDefinition[]{CASENUMBER, COMMENTTEXT})).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("author", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("date", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("text", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = AddCommentRequestHandler.this.getAPI(context, operation);
                String caseNumberString = BaseRequestHandler.CASENUMBER.resolveModelAttribute(context, operation).asString();
                String commentTextString = COMMENTTEXT.resolveModelAttribute(context, operation).asString();
                Comment comment = new Comment();
                comment.setCaseNumber(caseNumberString);
                comment.setText(commentTextString);
                try {
                    comment = api.getComments().add(comment);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                if (comment.getCreatedBy() != null) {
                    response.get("author").set(comment.getCreatedBy());
                }
                if (comment.getCreatedDate() != null) {
                    response.get("date").set(comment.getCreatedDate().getTime().toString());
                }
                if (comment.getText() != null) {
                    response.get("text").set(comment.getText());
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

