/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;

class LoggingResourceTransformer
implements ResourceTransformer {
    static final LoggingResourceTransformer INSTANCE = new LoggingResourceTransformer(new AttributeDefinition[0]);
    private final AttributeDefinition[] removableAttributes;

    public LoggingResourceTransformer(AttributeDefinition ... removableAttributes) {
        this.removableAttributes = removableAttributes;
    }

    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        this.doTransform((TransformationContext)context, address, resource);
        ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        childContext.processChildren(resource);
    }

    void doTransform(TransformationContext context, PathAddress address, Resource resource) {
        ModelNode model = resource.getModel();
        for (AttributeDefinition attribute : this.removableAttributes) {
            if (!model.has(attribute.getName())) continue;
            LoggingLogger.ROOT_LOGGER.debugf("Removing attribute '%s' during transform", attribute.getName());
            model.remove(attribute.getName());
        }
        if (model.hasDefined(CommonAttributes.LEVEL.getName()) && model.get(CommonAttributes.LEVEL.getName()).asString().equals("ALL")) {
            model.remove(CommonAttributes.LEVEL.getName());
        }
        if (model.hasDefined(CommonAttributes.FORMATTER.getName())) {
            String currentPattern = model.get(CommonAttributes.FORMATTER.getName()).asString();
            model.get(CommonAttributes.FORMATTER.getName()).set(Logging.fixFormatPattern(currentPattern));
        }
    }
}

