/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;
import org.rhq.plugins.hosts.helper.SimpleUnixConfigFileLine;

public class SimpleUnixConfigFileReader {
    private BufferedReader bufferedReader;
    private boolean trimWhitespace;

    public SimpleUnixConfigFileReader(Reader reader) {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    @Nullable
    public SimpleUnixConfigFileLine readLine() throws IOException {
        String comment;
        String nonComment;
        String line = this.bufferedReader.readLine();
        if (line == null) {
            return null;
        }
        int hashIndex = line.indexOf(35);
        if (hashIndex != -1) {
            nonComment = line.substring(0, hashIndex);
            comment = line.substring(hashIndex + 1);
        } else {
            nonComment = line;
            comment = null;
        }
        if (this.trimWhitespace) {
            if (nonComment != null) {
                nonComment = nonComment.trim();
            }
            if (comment != null) {
                comment = comment.trim();
            }
        }
        return new SimpleUnixConfigFileLine(nonComment, comment);
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }
}

