/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ignored.IgnoredDomainTypeResourceDefinition;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.parsing.JvmXml;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class HostXml
extends CommonXml
implements ManagementXml.Delegate {
    private final String defaultHostControllerName;

    public HostXml(String defaultHostControllerName) {
        this.defaultHostControllerName = defaultHostControllerName;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.HOST) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS) {
            case DOMAIN_1_0: {
                this.readHostElement_1_0(reader, address, operationList);
                break;
            }
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: {
                this.readHostElement_1_1(readerNS, reader, address, operationList);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        boolean hasCoreServices;
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.HOST.getLocalName());
        if (modelNode.hasDefined("name")) {
            HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)modelNode.get("name").asString());
        }
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"), false);
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if ((hasCoreServices = modelNode.hasDefined("core-service")) && modelNode.get("core-service").hasDefined("vault")) {
            this.writeVault(writer, modelNode.get(new String[]{"core-service", "vault"}));
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (hasCoreServices && modelNode.get("core-service").hasDefined("management")) {
            ManagementXml managementXml = new ManagementXml((ManagementXml.Delegate)this);
            managementXml.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("domain-controller")) {
            ModelNode ignoredResources = null;
            if (hasCoreServices && modelNode.get("core-service").hasDefined("ignored-resources") && modelNode.get(new String[]{"core-service", "ignored-resources"}).hasDefined("ignored-resource-type")) {
                ignoredResources = modelNode.get(new String[]{"core-service", "ignored-resources", "ignored-resource-type"});
            }
            this.writeDomainController(writer, modelNode.get("domain-controller"), ignoredResources);
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("jvm")) {
            writer.writeStartElement(Element.JVMS.getLocalName());
            for (Property jvm : modelNode.get("jvm").asPropertyList()) {
                JvmXml.writeJVMElement(writer, jvm.getName(), jvm.getValue());
            }
            writer.writeEndElement();
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("server-config")) {
            writer.writeStartElement(Element.SERVERS.getLocalName());
            HostResourceDefinition.DIRECTORY_GROUPING.marshallAsAttribute(modelNode, (XMLStreamWriter)writer);
            this.writeServers(writer, modelNode.get("server-config"));
            HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        HostXml.writeNewLine((XMLExtendedStreamWriter)writer);
        writer.writeEndDocument();
    }

    private void readHostElement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hostName = null;
        LinkedList namespaceOperations = new LinkedList();
        this.parseNamespaces(reader, address, namespaceOperations);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            hostName = value;
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, namespaceOperations, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.addLocalHost(address, list, hostName);
        for (ModelNode operation : namespaceOperations) {
            operation.get("address").set(address);
            list.add(operation);
        }
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, Namespace.DOMAIN_1_0, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = new ManagementXml((ManagementXml.Delegate)this);
            managementXml.parseManagement(reader, address, Namespace.DOMAIN_1_0, list, true, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.DOMAIN_CONTROLLER) {
            this.parseDomainController(reader, address, Namespace.DOMAIN_1_0, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        HashSet interfaceNames = new HashSet();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.JVMS) {
            this.parseJvms(reader, address, Namespace.DOMAIN_1_0, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.SERVERS) {
            this.parseServers_1_0(reader, address, Namespace.DOMAIN_1_0, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readHostElement_1_1(Namespace namespace, XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hostName = null;
        LinkedList namespaceOperations = new LinkedList();
        this.parseNamespaces(reader, address, namespaceOperations);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            hostName = value;
                            continue block14;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, namespaceOperations, i);
                            continue block14;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block14;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.addLocalHost(address, list, hostName);
        for (ModelNode operation : namespaceOperations) {
            operation.get("address").set(address);
            list.add(operation);
        }
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element != Element.MANAGEMENT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT));
        }
        ManagementXml managementXml = new ManagementXml((ManagementXml.Delegate)this);
        managementXml.parseManagement(reader, address, namespace, list, true, true);
        element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        if (element == Element.DOMAIN_CONTROLLER) {
            this.parseDomainController(reader, address, namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        HashSet interfaceNames = new HashSet();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.JVMS) {
            this.parseJvms(reader, address, namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.SERVERS) {
            switch (namespace) {
                case DOMAIN_1_1: {
                    this.parseServers_1_0(reader, address, namespace, list);
                    break;
                }
                default: {
                    this.parseServers_1_2(reader, address, namespace, list);
                }
            }
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        EnumSet<Element> required = EnumSet.of(Element.NATIVE_INTERFACE);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            required.remove(element);
            switch (element) {
                case NATIVE_INTERFACE: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseNativeManagementInterface1_0(reader, address, list);
                            continue block10;
                        }
                    }
                    this.parseManagementInterface1_1(reader, address, false, expectedNs, list);
                    continue block10;
                }
                case HTTP_INTERFACE: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseHttpManagementInterface1_0(reader, address, list);
                            continue block10;
                        }
                    }
                    this.parseManagementInterface1_1(reader, address, true, expectedNs, list);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseHttpManagementInterface1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "http-interface");
        mgmtSocket.get("address").set(operationAddress);
        boolean hasInterfaceName = false;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    HttpManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    hasInterfaceName = true;
                    continue block7;
                }
                case PORT: {
                    HttpManagementResourceDefinition.HTTP_PORT.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block7;
                }
                case SECURE_PORT: {
                    HttpManagementResourceDefinition.HTTPS_PORT.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block7;
                }
                case MAX_THREADS: {
                    continue block7;
                }
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterfaceName) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(mgmtSocket);
    }

    private void parseNativeManagementInterface1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-interface");
        mgmtSocket.get("address").set(operationAddress);
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    NativeManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    hasInterface = true;
                    continue block6;
                }
                case PORT: {
                    NativeManagementResourceDefinition.NATIVE_PORT.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block6;
                }
                case SECURE_PORT: {
                    continue block6;
                }
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(mgmtSocket);
    }

    private void parseManagementInterface1_1(XMLExtendedStreamReader reader, ModelNode address, boolean http, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", http ? "http-interface" : "native-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    if (http) {
                        HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                        continue block7;
                    }
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case CONSOLE_ENABLED: {
                    if (http) {
                        HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    if (http) {
                        this.parseHttpManagementSocket(reader, addOp);
                        continue block8;
                    }
                    this.parseNativeManagementSocket(reader, addOp);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseNativeManagementSocket(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    NativeManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasInterface = true;
                    continue block4;
                }
                case PORT: {
                    NativeManagementResourceDefinition.NATIVE_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
    }

    private void parseHttpManagementSocket(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    HttpManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasInterface = true;
                    continue block5;
                }
                case PORT: {
                    HttpManagementResourceDefinition.HTTP_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SECURE_PORT: {
                    HttpManagementResourceDefinition.HTTPS_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
    }

    private void addLocalHost(ModelNode address, List<ModelNode> operationList, String hostName) {
        String resolvedHost = hostName != null ? hostName : this.defaultHostControllerName;
        address.add("host", resolvedHost);
        ModelNode hostAdd = new ModelNode();
        hostAdd.get("operation").set("register-host-model");
        hostAdd.get("name").set(resolvedHost);
        hostAdd.get("address").setEmptyList();
        operationList.add(hostAdd);
        ModelNode nameValue = hostName == null ? new ModelNode() : new ModelNode(hostName);
        ModelNode writeName = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (ModelNode)nameValue);
        operationList.add(writeName);
    }

    private void parseDomainController(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean hasLocal = false;
        boolean hasRemote = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LOCAL: {
                    if (hasLocal) {
                        throw ControllerMessages.MESSAGES.childAlreadyDeclared(element.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    if (hasRemote) {
                        throw ControllerMessages.MESSAGES.childAlreadyDeclared(Element.REMOTE.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    hasLocal = true;
                    continue block7;
                }
                case REMOTE: {
                    if (hasRemote) {
                        throw ControllerMessages.MESSAGES.childAlreadyDeclared(element.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    if (hasLocal) {
                        throw ControllerMessages.MESSAGES.childAlreadyDeclared(Element.LOCAL.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseRemoteDomainController1_0(reader, address, list);
                            break;
                        }
                        default: {
                            this.parseRemoteDomainController1_1(reader, address, expectedNs, list);
                        }
                    }
                    hasRemote = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!hasLocal && !hasRemote) {
            throw ControllerMessages.MESSAGES.domainControllerMustBeDeclared(Element.REMOTE.getLocalName(), Element.LOCAL.getLocalName(), reader.getLocation());
        }
        if (hasLocal) {
            ModelNode update = new ModelNode();
            update.get("address").set(address);
            update.get("operation").set("write-local-domain-controller");
            list.add(update);
        }
    }

    private void parseRemoteDomainController1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseRemoteDomainControllerAttributes_1_0(reader, address, list);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteDomainController1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_1: 
            case DOMAIN_1_2: {
                this.parseRemoteDomainControllerAttributes_1_0(reader, address, list);
                break;
            }
            default: {
                this.parseRemoteDomainControllerAttributes_1_3(reader, address, list);
            }
        }
        HashSet<String> types = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case IGNORED_RESOURCE: {
                    this.parseIgnoredResource(reader, address, expectedNs, list, types);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteDomainControllerAttributes_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String host = null;
        ModelNode port = null;
        String securityRealm = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    host = value;
                    continue block7;
                }
                case PORT: {
                    port = ParseUtils.parsePossibleExpression((String)value);
                    if (port.getType() == ModelType.EXPRESSION) continue block7;
                    try {
                        int portNo = Integer.parseInt(value);
                        if (portNo >= 1) continue block7;
                        throw ControllerMessages.MESSAGES.invalidPort(attribute.getLocalName(), value, reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw ControllerMessages.MESSAGES.invalidPort(attribute.getLocalName(), value, reader.getLocation());
                    }
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (host == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.HOST.getLocalName()));
        }
        if (port == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PORT.getLocalName()));
        }
        ModelNode update = new ModelNode();
        update.get("address").set(address);
        update.get("operation").set("write-remote-domain-controller");
        update.get("host").set(ParseUtils.parsePossibleExpression((String)host));
        update.get("port").set(port);
        if (securityRealm != null) {
            update.get("security-realm").set(securityRealm);
        }
        list.add(update);
    }

    private void parseRemoteDomainControllerAttributes_1_3(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String host = null;
        ModelNode port = null;
        String securityRealm = null;
        String username = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    host = value;
                    continue block8;
                }
                case PORT: {
                    port = ParseUtils.parsePossibleExpression((String)value);
                    if (port.getType() == ModelType.EXPRESSION) continue block8;
                    try {
                        int portNo = Integer.parseInt(value);
                        if (portNo >= 1) continue block8;
                        throw ControllerMessages.MESSAGES.invalidPort(attribute.getLocalName(), value, reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw ControllerMessages.MESSAGES.invalidPort(attribute.getLocalName(), value, reader.getLocation());
                    }
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block8;
                }
                case USERNAME: {
                    username = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (host == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.HOST.getLocalName()));
        }
        if (port == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PORT.getLocalName()));
        }
        ModelNode update = new ModelNode();
        update.get("address").set(address);
        update.get("operation").set("write-remote-domain-controller");
        update.get("host").set(ParseUtils.parsePossibleExpression((String)host));
        update.get("port").set(port);
        if (securityRealm != null) {
            update.get("security-realm").set(securityRealm);
        }
        if (username != null) {
            update.get("username").set(username);
        }
        list.add(update);
    }

    private void parseIgnoredResource(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Set<String> foundTypes) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        String type = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if (!foundTypes.add(value)) {
                        throw HostControllerMessages.MESSAGES.duplicateIgnoredResourceType(Element.IGNORED_RESOURCE.getLocalName(), value, reader.getLocation());
                    }
                    type = value;
                    continue block7;
                }
                case WILDCARD: {
                    IgnoredDomainTypeResourceDefinition.WILDCARD.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (type == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE.getLocalName()));
        }
        ModelNode addr = op.get("address").set(address);
        addr.add("core-service", "ignored-resources");
        addr.add("ignored-resource-type", type);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INSTANCE: {
                    String name = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    IgnoredDomainTypeResourceDefinition.NAMES.parseAndAddParameterElement(name, op, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(op);
    }

    private void parseJvms(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JVM: {
                    JvmXml.parseJvm(reader, address, expectedNs, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServersAttributes(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIRECTORY_GROUPING: {
                    ModelNode address = parentAddress.clone();
                    list.add(Util.getWriteAttributeOperation((ModelNode)address, (String)"directory-grouping", (ModelNode)HostResourceDefinition.DIRECTORY_GROUPING.parse(value, (XMLStreamReader)reader)));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseServers_1_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, address, expectedNs, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServers_1_2(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseServersAttributes(reader, address, list);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, address, expectedNs, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServer(XMLExtendedStreamReader reader, ModelNode parentAddress, Namespace expectedNs, List<ModelNode> list, Set<String> serverNames) throws XMLStreamException {
        ModelNode addUpdate = this.parseServerAttributes(reader, parentAddress, serverNames);
        ModelNode address = addUpdate.require("address");
        list.add(addUpdate);
        switch (expectedNs) {
            case DOMAIN_1_0: {
                this.parseServerContent1_0(reader, addUpdate, address, expectedNs, list);
                break;
            }
            default: {
                this.parseServerContent1_1(reader, addUpdate, address, expectedNs, list);
            }
        }
    }

    private void parseServerContent1_0(XMLExtendedStreamReader reader, ModelNode serverAddOperation, ModelNode serverAddress, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        boolean sawJvm = false;
        boolean sawSystemProperties = false;
        boolean sawSocketBinding = false;
        HashSet interfaceNames = new HashSet();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INTERFACE_SPECS: {
                    this.parseInterfaces(reader, interfaceNames, serverAddress, expectedNs, list, true);
                    continue block7;
                }
                case JVM: {
                    if (sawJvm) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseJvm(reader, serverAddress, expectedNs, list, new HashSet<String>(), true);
                    sawJvm = true;
                    continue block7;
                }
                case PATHS: {
                    this.parsePaths(reader, serverAddress, expectedNs, list, true);
                    continue block7;
                }
                case SOCKET_BINDING_GROUP: {
                    if (sawSocketBinding) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseSocketBindingGroupRef(reader, serverAddOperation, ServerConfigResourceDefinition.SOCKET_BINDING_GROUP, ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET);
                    sawSocketBinding = true;
                    continue block7;
                }
                case SYSTEM_PROPERTIES: {
                    if (sawSystemProperties) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseSystemProperties(reader, serverAddress, expectedNs, list, false);
                    sawSystemProperties = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerContent1_1(XMLExtendedStreamReader reader, ModelNode serverAddOperation, ModelNode serverAddress, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        boolean sawJvm = false;
        boolean sawSystemProperties = false;
        boolean sawSocketBinding = false;
        HashSet interfaceNames = new HashSet();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INTERFACES: {
                    this.parseInterfaces(reader, interfaceNames, serverAddress, expectedNs, list, true);
                    continue block7;
                }
                case JVM: {
                    if (sawJvm) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseJvm(reader, serverAddress, expectedNs, list, new HashSet<String>(), true);
                    sawJvm = true;
                    continue block7;
                }
                case PATHS: {
                    this.parsePaths(reader, serverAddress, expectedNs, list, true);
                    continue block7;
                }
                case SOCKET_BINDINGS: {
                    if (sawSocketBinding) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseServerSocketBindings(reader, serverAddOperation);
                    sawSocketBinding = true;
                    continue block7;
                }
                case SYSTEM_PROPERTIES: {
                    if (sawSystemProperties) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseSystemProperties(reader, serverAddress, expectedNs, list, false);
                    sawSystemProperties = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseServerAttributes(XMLExtendedStreamReader reader, ModelNode parentAddress, Set<String> serverNames) throws XMLStreamException {
        ModelNode addUpdate = new ModelNode();
        addUpdate.get("operation").set("add");
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.GROUP);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    if (!serverNames.add(value)) {
                        throw ControllerMessages.MESSAGES.duplicateDeclaration("server", value, reader.getLocation());
                    }
                    ModelNode address = parentAddress.clone().add("server-config", value);
                    addUpdate.get("address").set(address);
                    continue block5;
                }
                case GROUP: {
                    ServerConfigResourceDefinition.GROUP.parseAndSetParameter(value, addUpdate, (XMLStreamReader)reader);
                    continue block5;
                }
                case AUTO_START: {
                    ServerConfigResourceDefinition.AUTO_START.parseAndSetParameter(value, addUpdate, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        return addUpdate;
    }

    private void parseServerSocketBindings(XMLExtendedStreamReader reader, ModelNode serverAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOCKET_BINDING_GROUP: {
                    ServerConfigResourceDefinition.SOCKET_BINDING_GROUP.parseAndSetParameter(value, serverAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case PORT_OFFSET: {
                    ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET.parseAndSetParameter(value, serverAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public void writeNativeManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.NATIVE_INTERFACE.getLocalName());
        NativeManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEmptyElement(Element.SOCKET.getLocalName());
        NativeManagementResourceDefinition.INTERFACE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.NATIVE_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    public void writeHttpManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.HTTP_INTERFACE.getLocalName());
        HttpManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.CONSOLE_ENABLED.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEmptyElement(Element.SOCKET.getLocalName());
        HttpManagementResourceDefinition.INTERFACE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.HTTP_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.HTTPS_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeDomainController(XMLExtendedStreamWriter writer, ModelNode modelNode, ModelNode ignoredResources) throws XMLStreamException {
        writer.writeStartElement(Element.DOMAIN_CONTROLLER.getLocalName());
        if (modelNode.hasDefined("local")) {
            writer.writeEmptyElement(Element.LOCAL.getLocalName());
        } else if (modelNode.hasDefined("remote")) {
            writer.writeStartElement(Element.REMOTE.getLocalName());
            ModelNode remote = modelNode.get("remote");
            if (remote.has("host")) {
                HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.HOST, (String)remote.get("host").asString());
            }
            if (remote.has("port")) {
                HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.PORT, (String)remote.get("port").asString());
            }
            if (remote.hasDefined("security-realm")) {
                HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.SECURITY_REALM, (String)remote.require("security-realm").asString());
            }
            if (remote.hasDefined("username")) {
                HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.USERNAME, (String)remote.require("username").asString());
            }
            if (ignoredResources != null) {
                this.writeIgnoredResources(writer, ignoredResources);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeIgnoredResources(XMLExtendedStreamWriter writer, ModelNode ignoredTypes) throws XMLStreamException {
        for (Property property : ignoredTypes.asPropertyList()) {
            boolean hasNames;
            ModelNode ignored = property.getValue();
            ModelNode names = ignored.hasDefined("names") ? ignored.get("names") : null;
            boolean bl = hasNames = names != null && names.asInt() > 0;
            if (hasNames) {
                writer.writeStartElement(Element.IGNORED_RESOURCE.getLocalName());
            } else {
                writer.writeEmptyElement(Element.IGNORED_RESOURCE.getLocalName());
            }
            writer.writeAttribute(Attribute.TYPE.getLocalName(), property.getName());
            IgnoredDomainTypeResourceDefinition.WILDCARD.marshallAsAttribute(ignored, (XMLStreamWriter)writer);
            if (!hasNames) continue;
            for (ModelNode name : names.asList()) {
                writer.writeEmptyElement(Element.INSTANCE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name.asString());
            }
            writer.writeEndElement();
        }
    }

    private void writeServers(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (Property prop : modelNode.asPropertyList()) {
            Iterator i$;
            ModelNode server = prop.getValue();
            writer.writeStartElement(Element.SERVER.getLocalName());
            HostXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)prop.getName());
            ServerConfigResourceDefinition.GROUP.marshallAsAttribute(server, (XMLStreamWriter)writer);
            ServerConfigResourceDefinition.AUTO_START.marshallAsAttribute(server, (XMLStreamWriter)writer);
            if (server.hasDefined("path")) {
                this.writePaths(writer, server.get("path"), false);
            }
            if (server.hasDefined("system-property")) {
                this.writeProperties(writer, server.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            }
            if (server.hasDefined("interface")) {
                this.writeInterfaces(writer, server.get("interface"));
            }
            if (server.hasDefined("jvm") && (i$ = server.get("jvm").asPropertyList().iterator()).hasNext()) {
                Property jvm = (Property)i$.next();
                JvmXml.writeJVMElement(writer, jvm.getName(), jvm.getValue());
            }
            if (server.hasDefined("socket-binding-group") || server.hasDefined("socket-binding-port-offset")) {
                writer.writeStartElement(Element.SOCKET_BINDINGS.getLocalName());
                ServerConfigResourceDefinition.SOCKET_BINDING_GROUP.marshallAsAttribute(server, (XMLStreamWriter)writer);
                ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET.marshallAsAttribute(server, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

