/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.dmr.ModelNode;

public abstract class ServerRestartRequiredServerConfigWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler GROUP_INSTANCE = new GroupHandler();
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler SOCKET_BINDING_GROUP_INSTANCE = new SocketBindingGroupHandler();
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler SOCKET_BINDING_PORT_OFFSET_INSTANCE = new SocketBindingPortOffsetHandler();
    private final AttributeDefinition attributeDefinition;

    protected ServerRestartRequiredServerConfigWriteAttributeHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, Resource resource) throws OperationFailedException {
        ModelNode resolvedValue;
        if (newValue.equals(currentValue)) {
            ServerOperationResolver.addToDontPropagateToServersAttachment(context, operation);
        }
        if ((resolvedValue = this.attributeDefinition.resolveModelAttribute(context, resource.getModel())).isDefined()) {
            this.validateReferencedNewValueExists(context, resolvedValue);
        }
    }

    protected abstract void validateReferencedNewValueExists(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private static class SocketBindingPortOffsetHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public SocketBindingPortOffsetHandler() {
            super((AttributeDefinition)ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET);
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode resolvedValue) throws OperationFailedException {
        }
    }

    private static class SocketBindingGroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public SocketBindingGroupHandler() {
            super((AttributeDefinition)ServerConfigResourceDefinition.SOCKET_BINDING_GROUP);
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode resolvedValue) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"socket-binding-group", (String)resolvedValue.asString())) == null) {
                throw HostControllerMessages.MESSAGES.noSocketBindingGroupCalled(resolvedValue.asString());
            }
        }
    }

    private static class GroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public GroupHandler() {
            super((AttributeDefinition)ServerConfigResourceDefinition.GROUP);
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode resolvedValue) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"server-group", (String)resolvedValue.asString())) == null) {
                throw HostControllerMessages.MESSAGES.noServerGroupCalled(resolvedValue.asString());
            }
        }
    }
}

