/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.CLibrary;
import org.rhq.cassandra.ClusterInitService;
import org.rhq.cassandra.Deployer;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;

public class CassandraClusterManager {
    private final Log log = LogFactory.getLog(CassandraClusterManager.class);
    private DeploymentOptions deploymentOptions;
    private List<File> installedNodeDirs = new ArrayList<File>();
    private Map<Integer, Process> nodeProcessMap = new HashMap<Integer, Process>();
    private String[] nodes;
    private int[] jmxPorts;
    private int cqlPort;

    public CassandraClusterManager() {
        this(new DeploymentOptionsFactory().newDeploymentOptions());
    }

    public CassandraClusterManager(DeploymentOptions deploymentOptions) {
        SystemInfoFactory.disableNativeSystemInfo();
        this.deploymentOptions = deploymentOptions;
        try {
            this.deploymentOptions.load();
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to load deployment options", (Throwable)e);
            throw new IllegalStateException("An initialization error occurred.", e);
        }
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public int[] getJmxPorts() {
        return this.jmxPorts;
    }

    public int getCqlPort() {
        return this.cqlPort;
    }

    public void createCluster() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Installing embedded " + this.deploymentOptions.getNumNodes() + " node cluster to " + this.deploymentOptions.getClusterDir()));
        } else {
            this.log.info((Object)"Installing embedded cluster");
        }
        File clusterDir = new File(this.deploymentOptions.getClusterDir());
        File installedMarker = new File(clusterDir, ".installed");
        if (installedMarker.exists()) {
            this.log.info((Object)("It appears that the cluster already exists in " + clusterDir));
            this.log.info((Object)"Skipping cluster creation.");
            this.getStorageClusterConfiguration();
        }
        FileUtil.purge((File)clusterDir, (boolean)false);
        String seeds = StringUtil.collectionToString(this.calculateLocalIPAddresses(this.deploymentOptions.getNumNodes()));
        this.nodes = new String[this.deploymentOptions.getNumNodes()];
        this.jmxPorts = new int[this.deploymentOptions.getNumNodes()];
        this.cqlPort = this.deploymentOptions.getCqlPort();
        for (int i = 0; i < this.deploymentOptions.getNumNodes(); ++i) {
            File basedir = new File(this.deploymentOptions.getClusterDir(), "node" + i);
            String address = this.getLocalIPAddress(i + 1);
            DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
            DeploymentOptions nodeOptions = factory.newDeploymentOptions();
            nodeOptions.setSeeds(seeds);
            nodeOptions.setJmxPort(this.deploymentOptions.getJmxPort() + i);
            nodeOptions.setBasedir(basedir.getAbsolutePath());
            nodeOptions.setListenAddress(address);
            nodeOptions.setRpcAddress(address);
            nodeOptions.setCommitLogDir(new File(basedir, "commit_log").getAbsolutePath());
            nodeOptions.setDataDir(new File(basedir, "data").getAbsolutePath());
            nodeOptions.setSavedCachesDir(new File(basedir, "saved_caches").getAbsolutePath());
            nodeOptions.merge(this.deploymentOptions);
            try {
                nodeOptions.load();
                Deployer deployer = new Deployer();
                deployer.setDeploymentOptions(nodeOptions);
                deployer.unzipDistro();
                deployer.applyConfigChanges();
                deployer.updateFilePerms();
                deployer.updateStorageAuthConf(this.calculateLocalIPAddresses(this.deploymentOptions.getNumNodes()));
                this.nodes[i] = address;
                this.jmxPorts[i] = this.deploymentOptions.getJmxPort() + i;
                this.installedNodeDirs.add(basedir);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to install node at " + basedir));
                throw new RuntimeException("Failed to install node at " + basedir, e);
            }
        }
        try {
            FileUtil.writeFile((InputStream)new ByteArrayInputStream(new byte[]{0}), (File)installedMarker);
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to write installed file marker to " + installedMarker), (Throwable)e);
        }
    }

    private void updateStorageAuthConf(File basedir) {
        File confDir = new File(basedir, "conf");
        File authFile = new File(confDir, "rhq-storage-auth.conf");
        authFile.delete();
        Set<String> addresses = this.calculateLocalIPAddresses(this.deploymentOptions.getNumNodes());
        try {
            StreamUtil.copy((Reader)new StringReader(StringUtil.collectionToString(addresses, (String)"\n")), (Writer)new FileWriter(authFile), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update " + authFile);
        }
    }

    private Set<String> calculateLocalIPAddresses(int numNodes) {
        HashSet<String> addresses = new HashSet<String>();
        for (int i = 1; i <= numNodes; ++i) {
            addresses.add(this.getLocalIPAddress(i));
        }
        return addresses;
    }

    private String getLocalIPAddress(int i) {
        String seeds = this.deploymentOptions.getSeeds();
        if (null == seeds || seeds.isEmpty() || "localhost".equals(seeds)) {
            return "127.0.0." + i;
        }
        String[] seedsArray = seeds.split(",");
        return i <= seedsArray.length ? seedsArray[i - 1] : "127.0.0." + i;
    }

    private void getStorageClusterConfiguration() {
        this.nodes = new String[this.deploymentOptions.getNumNodes()];
        this.jmxPorts = new int[this.deploymentOptions.getNumNodes()];
        for (int i = 0; i < this.deploymentOptions.getNumNodes(); ++i) {
            this.nodes[i] = this.getLocalIPAddress(i + 1);
            this.jmxPorts[i] = this.deploymentOptions.getJmxPort() + i;
        }
        this.cqlPort = this.deploymentOptions.getCqlPort();
    }

    public void startCluster() {
        this.startCluster(true);
    }

    public void startCluster(boolean waitForClusterToStart) {
        this.startCluster(this.getNodeIds());
        if (waitForClusterToStart) {
            this.getStorageClusterConfiguration();
            ClusterInitService clusterInitService = new ClusterInitService();
            clusterInitService.waitForClusterToStart(this.nodes, this.jmxPorts, this.nodes.length, 20);
        }
    }

    public void startCluster(List<Integer> nodeIds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting embedded cluster for nodes " + StringUtil.collectionToString(nodeIds)));
        } else {
            this.log.info((Object)"Starting embedded cluster");
        }
        long start = System.currentTimeMillis();
        File basedir = new File(this.deploymentOptions.getClusterDir());
        for (Integer nodeId : nodeIds) {
            File nodeDir = new File(basedir, "node" + nodeId);
            ProcessExecutionResults results = this.startNode(nodeDir);
            if (results.getError() != null) {
                this.log.warn((Object)("An unexpected error occurred while starting the node at " + nodeDir), results.getError());
                continue;
            }
            this.nodeProcessMap.put(nodeId, results.getProcess());
        }
        long end = System.currentTimeMillis();
        this.log.info((Object)("Started embedded cluster in " + (end - start) + " ms"));
    }

    private ProcessExecutionResults startNode(File basedir) {
        ProcessExecution startScriptExe;
        File startScript;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting node at " + basedir));
        }
        File binDir = new File(basedir, "bin");
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        if (systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS) {
            startScript = new File(binDir, "cassandra.bat");
            startScriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
        } else {
            startScript = new File(binDir, "cassandra");
            startScriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
            startScriptExe.addArguments(Arrays.asList("-p", "cassandra.pid"));
        }
        startScriptExe.setWaitForCompletion(0L);
        ProcessExecutionResults results = systemInfo.executeProcess(startScriptExe);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(startScript + " returned with exit code [" + results.getExitCode() + "]"));
        }
        return results;
    }

    public void shutdownCluster() {
        this.shutdown(this.getNodeIds());
    }

    public void shutdown(List<Integer> nodeIds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Preparing to shutdown cluster nodes " + StringUtil.collectionToString(nodeIds)));
        } else {
            this.log.info((Object)"Preparing to shutdown cluster nodes.");
        }
        File basedir = new File(this.deploymentOptions.getClusterDir());
        for (Integer nodeId : nodeIds) {
            File nodeDir = new File(basedir, "node" + nodeId);
            this.log.debug((Object)("Shutting down node at " + nodeDir));
            try {
                Process nodeProcess;
                if (!nodeDir.exists()) {
                    this.log.warn((Object)("No shutdown to perform. " + nodeDir + " does not exist."));
                    continue;
                }
                try {
                    this.killNode(nodeDir);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Unable to kill nodeDir [" + nodeDir + "]"), t);
                }
                if (null == (nodeProcess = this.nodeProcessMap.get(nodeId))) continue;
                try {
                    nodeProcess.destroy();
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Failed to kill Cassandra node " + nodeDir), t);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("An error occurred trying to shutdown node at " + nodeDir));
            }
        }
    }

    private List<Integer> getNodeIds() {
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (int i = 0; i < this.deploymentOptions.getNumNodes(); ++i) {
            nodeIds.add(i);
        }
        return nodeIds;
    }

    public void killNode(File nodeDir) throws Exception {
        long pid = this.getPid(nodeDir);
        CLibrary.kill((int)pid, 9);
    }

    private long getPid(File nodeDir) throws IOException {
        File binDir = new File(nodeDir, "bin");
        StringWriter writer = new StringWriter();
        StreamUtil.copy((Reader)new FileReader(new File(binDir, "cassandra.pid")), (Writer)writer);
        return Long.parseLong(writer.getBuffer().toString());
    }
}

