/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.datasources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.datasources.ExistingDataSource;

public class ScrollableDataSource
implements ExistingDataSource {
    private static final Log log = LogFactory.getLog(ScrollableDataSource.class);
    private final EntityManager entityManager;
    private final DataMigrator.DatabaseType databaseType;
    private final String selectNativeQuery;
    private final int maxResults;
    private ScrollableResults results;
    private StatelessSession session;
    private int lastMigratedItemIndex;

    public ScrollableDataSource(EntityManager entityManager, DataMigrator.DatabaseType databaseType, String selectNativeQuery) {
        this(entityManager, databaseType, selectNativeQuery, -1);
    }

    public ScrollableDataSource(EntityManager entityManager, DataMigrator.DatabaseType databaseType, String selectNativeQuery, int maxResults) {
        this.entityManager = entityManager;
        this.databaseType = databaseType;
        this.selectNativeQuery = selectNativeQuery;
        this.maxResults = maxResults;
    }

    @Override
    public List<Object[]> getData(int fromIndex, int maxResults) throws Exception {
        if (fromIndex != this.lastMigratedItemIndex + 1) {
            throw new Exception("Cursor error. " + fromIndex + " " + this.lastMigratedItemIndex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading lines " + fromIndex + " to " + (fromIndex + maxResults)));
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        int maxLimit = this.lastMigratedItemIndex + maxResults;
        while (this.results.next()) {
            resultList.add(this.results.get());
            if (++this.lastMigratedItemIndex != maxLimit) continue;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read lines " + fromIndex + " to " + (fromIndex + maxResults)));
        }
        return resultList;
    }

    @Override
    public void initialize() {
        if (this.session != null || this.results != null) {
            this.close();
        }
        this.session = ((Session)this.entityManager.getDelegate()).getSessionFactory().openStatelessSession();
        this.prepareSQLSession();
        if (log.isDebugEnabled()) {
            if (this.maxResults >= 0) {
                log.debug((Object)("Preparing the query with " + this.maxResults + " results."));
            } else {
                log.debug((Object)"Preparing the query with all the results.");
            }
        }
        SQLQuery query = this.session.createSQLQuery(this.selectNativeQuery);
        if (this.maxResults >= 0) {
            query.setMaxResults(this.maxResults);
        }
        query.setFetchSize(30000);
        query.setReadOnly(true);
        query.setTimeout(6000000);
        this.results = query.scroll(ScrollMode.FORWARD_ONLY);
        this.lastMigratedItemIndex = -1;
        if (log.isDebugEnabled()) {
            if (this.maxResults >= 0) {
                log.debug((Object)("Query prepared with " + this.maxResults + " results."));
            } else {
                log.debug((Object)"Query prepared with all the results.");
            }
        }
    }

    @Override
    public void close() {
        if (this.results != null) {
            this.results.close();
            this.results = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    private void prepareSQLSession() {
        if (DataMigrator.DatabaseType.Postgres.equals((Object)this.databaseType)) {
            log.debug((Object)"Preparing SQL connection with timeout: 6000000");
            SQLQuery query = this.session.createSQLQuery("SET LOCAL statement_timeout = 6000000");
            query.setReadOnly(true);
            query.executeUpdate();
        }
    }
}

