/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.EmailAddressImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;
import org.apache.ws.scout.registry.infomodel.PersonNameImpl;
import org.apache.ws.scout.registry.infomodel.PostalAddressImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.registry.infomodel.SpecificationLinkImpl;
import org.apache.ws.scout.registry.infomodel.TelephoneNumberImpl;
import org.apache.ws.scout.registry.infomodel.UserImpl;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoutUddiV3JaxrHelper {
    public static Association getAssociation(Collection orgs, LifeCycleManager lcm) throws JAXRException {
        AssociationImpl asso = new AssociationImpl(lcm);
        Object[] arr = orgs.toArray();
        asso.setSourceObject((RegistryObject)arr[0]);
        asso.setTargetObject((RegistryObject)arr[1]);
        return asso;
    }

    public static Organization getOrganization(BusinessEntity businessEntity, LifeCycleManager lifeCycleManager) throws JAXRException {
        DiscoveryURLs durls;
        List contactList;
        Contacts contacts;
        List descriptionList;
        OrganizationImpl org = new OrganizationImpl(lifeCycleManager);
        List namesList = businessEntity.getName();
        if (namesList != null && namesList.size() > 0) {
            InternationalString is = null;
            for (Name n : namesList) {
                if (is == null) {
                    is = ScoutUddiV3JaxrHelper.getIString(n.getLang(), n.getValue(), lifeCycleManager);
                    continue;
                }
                is.setValue(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
            }
            org.setName(is);
        }
        if ((descriptionList = businessEntity.getDescription()) != null && descriptionList.size() > 0) {
            InternationalString is = null;
            for (Description desc : descriptionList) {
                if (is == null) {
                    is = ScoutUddiV3JaxrHelper.getIString(desc.getLang(), desc.getValue(), lifeCycleManager);
                    continue;
                }
                is.setValue(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue());
            }
            org.setDescription(is);
        }
        org.setKey(lifeCycleManager.createKey(businessEntity.getBusinessKey()));
        BusinessServices services = businessEntity.getBusinessServices();
        if (services != null) {
            List bizServiceList = services.getBusinessService();
            for (BusinessService businessService : bizServiceList) {
                org.addService(ScoutUddiV3JaxrHelper.getService(businessService, lifeCycleManager));
            }
        }
        if ((contacts = businessEntity.getContacts()) != null && (contactList = contacts.getContact()) != null) {
            boolean isFirst = true;
            for (Contact contact : contactList) {
                UserImpl user = new UserImpl(null);
                List pname = contact.getPersonName();
                if (pname != null && pname.size() > 0) {
                    String name = ((PersonName)pname.get(0)).getValue();
                    user.setPersonName(new PersonNameImpl(name));
                }
                if (isFirst) {
                    isFirst = false;
                    org.setPrimaryContact(user);
                    continue;
                }
                org.addUser(user);
            }
        }
        if ((durls = businessEntity.getDiscoveryURLs()) != null) {
            List discoveryURL_List = durls.getDiscoveryURL();
            for (DiscoveryURL discoveryURL : discoveryURL_List) {
                ExternalLinkImpl link = new ExternalLinkImpl(lifeCycleManager);
                link.setExternalURI(discoveryURL.getValue());
                org.addExternalLink(link);
            }
        }
        org.addExternalIdentifiers(ScoutUddiV3JaxrHelper.getExternalIdentifiers(businessEntity.getIdentifierBag(), lifeCycleManager));
        org.addClassifications(ScoutUddiV3JaxrHelper.getClassifications(businessEntity.getCategoryBag(), lifeCycleManager));
        return org;
    }

    public static Organization getOrganization(BusinessDetail bizdetail, LifeCycleManager lifeCycleManager) throws JAXRException {
        DiscoveryURLs durls;
        Contacts contacts;
        List descriptionList;
        List bizEntityList = bizdetail.getBusinessEntity();
        OrganizationImpl org = new OrganizationImpl(lifeCycleManager);
        if (bizEntityList.size() != 1) {
            throw new JAXRException("Unexpected count of organizations in BusinessDetail: " + bizEntityList.size());
        }
        BusinessEntity entity = (BusinessEntity)bizEntityList.get(0);
        List namesList = entity.getName();
        if (namesList != null && namesList.size() > 0) {
            InternationalString is = null;
            for (Name n : namesList) {
                if (is == null) {
                    is = ScoutUddiV3JaxrHelper.getIString(n.getLang(), n.getValue(), lifeCycleManager);
                    continue;
                }
                is.setValue(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
            }
            org.setName(is);
        }
        if ((descriptionList = entity.getDescription()) != null && descriptionList.size() > 0) {
            InternationalString is = null;
            for (Description desc : descriptionList) {
                if (is == null) {
                    is = ScoutUddiV3JaxrHelper.getIString(desc.getLang(), desc.getValue(), lifeCycleManager);
                    continue;
                }
                is.setValue(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue());
            }
            org.setDescription(is);
        }
        org.setKey(lifeCycleManager.createKey(entity.getBusinessKey()));
        BusinessServices services = entity.getBusinessServices();
        if (services != null) {
            List bizServiceList = services.getBusinessService();
            for (BusinessService businessService : bizServiceList) {
                org.addService(ScoutUddiV3JaxrHelper.getService(businessService, lifeCycleManager));
            }
        }
        if ((contacts = entity.getContacts()) != null) {
            List contactList = contacts.getContact();
            boolean isFirst = true;
            for (Contact contact : contactList) {
                UserImpl user = new UserImpl(null);
                List pnames = contact.getPersonName();
                String pname = null;
                if (pnames != null && pnames.size() > 0) {
                    PersonName personname = (PersonName)pnames.get(0);
                    pname = personname.getValue();
                }
                user.setType(contact.getUseType());
                user.setPersonName(new PersonNameImpl(pname));
                List emailList = contact.getEmail();
                ArrayList<EmailAddressImpl> tempEmails = new ArrayList<EmailAddressImpl>();
                for (Email email : emailList) {
                    tempEmails.add(new EmailAddressImpl(email.getValue(), null));
                }
                user.setEmailAddresses(tempEmails);
                List addressList = contact.getAddress();
                ArrayList<PostalAddress> tempAddresses = new ArrayList<PostalAddress>();
                for (Address address : addressList) {
                    ArrayList addressLineList = new ArrayList(address.getAddressLine());
                    AddressLine[] alines = new AddressLine[addressLineList.size()];
                    addressLineList.toArray(alines);
                    PostalAddress pa = ScoutUddiV3JaxrHelper.getPostalAddress(alines);
                    tempAddresses.add(pa);
                }
                user.setPostalAddresses(tempAddresses);
                List phoneList = contact.getPhone();
                ArrayList<TelephoneNumberImpl> tempPhones = new ArrayList<TelephoneNumberImpl>();
                for (Phone phone : phoneList) {
                    TelephoneNumberImpl tni = new TelephoneNumberImpl();
                    tni.setType(phone.getUseType());
                    tni.setNumber(phone.getValue());
                    tempPhones.add(tni);
                }
                user.setTelephoneNumbers(tempPhones);
                if (isFirst) {
                    isFirst = false;
                    org.setPrimaryContact(user);
                    continue;
                }
                org.addUser(user);
            }
        }
        if ((durls = entity.getDiscoveryURLs()) != null) {
            List discoveryURL_List = durls.getDiscoveryURL();
            for (DiscoveryURL discoveryURL : discoveryURL_List) {
                ExternalLinkImpl link = new ExternalLinkImpl(lifeCycleManager);
                link.setExternalURI(discoveryURL.getValue());
                org.addExternalLink(link);
            }
        }
        org.addExternalIdentifiers(ScoutUddiV3JaxrHelper.getExternalIdentifiers(entity.getIdentifierBag(), lifeCycleManager));
        org.addClassifications(ScoutUddiV3JaxrHelper.getClassifications(entity.getCategoryBag(), lifeCycleManager));
        return org;
    }

    private static PostalAddress getPostalAddress(AddressLine[] addressLineArr) throws JAXRException {
        PostalAddressImpl pa = new PostalAddressImpl();
        HashMap<String, String> hm = new HashMap<String, String>();
        for (AddressLine anAddressLineArr : addressLineArr) {
            hm.put(anAddressLineArr.getKeyName(), anAddressLineArr.getValue());
        }
        if (hm.containsKey("STREET_NUMBER")) {
            pa.setStreetNumber((String)hm.get("STREET_NUMBER"));
        }
        if (hm.containsKey("STREET")) {
            pa.setStreet((String)hm.get("STREET"));
        }
        if (hm.containsKey("CITY")) {
            pa.setCity((String)hm.get("CITY"));
        }
        if (hm.containsKey("COUNTRY")) {
            pa.setCountry((String)hm.get("COUNTRY"));
        }
        if (hm.containsKey("POSTALCODE")) {
            pa.setPostalCode((String)hm.get("POSTALCODE"));
        }
        if (hm.containsKey("STATE")) {
            pa.setStateOrProvince((String)hm.get("STATE"));
        }
        return pa;
    }

    private static InternationalString getIString(String lang, String str, LifeCycleManager lifeCycleManager) throws JAXRException {
        if (str != null) {
            return lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(lang), str);
        }
        return null;
    }

    public static InternationalString getIString(String str, LifeCycleManager lifeCycleManager) throws JAXRException {
        return lifeCycleManager.createInternationalString(str);
    }

    public static Service getService(BusinessService businessService, LifeCycleManager lifeCycleManager) throws JAXRException {
        ServiceImpl serve = new ServiceImpl(lifeCycleManager);
        String keystr = businessService.getServiceKey();
        if (keystr != null) {
            serve.setKey(lifeCycleManager.createKey(keystr));
        }
        List namesList = businessService.getName();
        InternationalString is = null;
        for (Name n : namesList) {
            if (is == null) {
                is = lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
                continue;
            }
            is.setValue(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
        }
        serve.setName(is);
        List descriptionList = businessService.getDescription();
        InternationalString dis = null;
        for (Description desc : descriptionList) {
            if (dis == null) {
                dis = lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue());
                continue;
            }
            dis.setValue(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue());
        }
        serve.setDescription(dis);
        BindingTemplates bts = businessService.getBindingTemplates();
        if (bts != null) {
            List bindingTemplateList = bts.getBindingTemplate();
            for (BindingTemplate bindingTemplate : bindingTemplateList) {
                serve.addServiceBinding(ScoutUddiV3JaxrHelper.getServiceBinding(bindingTemplate, lifeCycleManager));
            }
        }
        serve.addClassifications(ScoutUddiV3JaxrHelper.getClassifications(businessService.getCategoryBag(), lifeCycleManager));
        return serve;
    }

    public static Service getService(ServiceInfo serviceInfo, LifeCycleManager lifeCycleManager) throws JAXRException {
        ServiceImpl service = new ServiceImpl(lifeCycleManager);
        String keystr = serviceInfo.getServiceKey();
        if (keystr != null) {
            service.setKey(lifeCycleManager.createKey(keystr));
        }
        List namesList = serviceInfo.getName();
        InternationalString is = null;
        for (Name n : namesList) {
            if (is == null) {
                is = lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
                continue;
            }
            is.setValue(ScoutUddiV3JaxrHelper.getLocale(n.getLang()), n.getValue());
        }
        service.setName(is);
        return service;
    }

    public static ServiceBinding getServiceBinding(BindingTemplate businessTemplate, LifeCycleManager lifeCycleManager) throws JAXRException {
        HostingRedirector hr;
        TModelInstanceDetails details;
        AccessPoint access;
        String bindingKey;
        ServiceBindingImpl serviceBinding = new ServiceBindingImpl(lifeCycleManager);
        String keystr = businessTemplate.getServiceKey();
        if (keystr != null) {
            ServiceImpl svc = new ServiceImpl(lifeCycleManager);
            svc.setKey(lifeCycleManager.createKey(keystr));
            serviceBinding.setService(svc);
        }
        if ((bindingKey = businessTemplate.getBindingKey()) != null) {
            serviceBinding.setKey(new KeyImpl(bindingKey));
        }
        if ((access = businessTemplate.getAccessPoint()) != null) {
            serviceBinding.setAccessURI(access.getValue());
        }
        Description desc = null;
        if (businessTemplate.getDescription().size() > 0) {
            desc = (Description)businessTemplate.getDescription().get(0);
        }
        if (desc != null) {
            serviceBinding.setDescription(new InternationalStringImpl(desc.getValue()));
        }
        if ((details = businessTemplate.getTModelInstanceDetails()) != null) {
            List tmodelInstanceInfoList = details.getTModelInstanceInfo();
            for (TModelInstanceInfo info : tmodelInstanceInfoList) {
                if (info == null || info.getInstanceDetails() == null) continue;
                InstanceDetails idetails = info.getInstanceDetails();
                Collection<ExternalLink> elinks = ScoutUddiV3JaxrHelper.getExternalLinks(idetails.getOverviewDoc(), lifeCycleManager);
                SpecificationLinkImpl slink = new SpecificationLinkImpl(lifeCycleManager);
                slink.addExternalLinks(elinks);
                serviceBinding.addSpecificationLink(slink);
                ConceptImpl c = new ConceptImpl(lifeCycleManager);
                c.setExternalLinks(elinks);
                c.setKey(lifeCycleManager.createKey(info.getTModelKey()));
                c.setName(lifeCycleManager.createInternationalString(idetails.getInstanceParms()));
                c.setValue(idetails.getInstanceParms());
                slink.setSpecificationObject(c);
            }
        }
        if ((hr = businessTemplate.getHostingRedirector()) != null) {
            ServiceBinding sb = lifeCycleManager.createServiceBinding();
            sb.setKey((Key)new KeyImpl(hr.getBindingKey()));
            serviceBinding.setTargetBinding(sb);
        }
        return serviceBinding;
    }

    public static Concept getConcept(TModelDetail tModelDetail, LifeCycleManager lifeCycleManager) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lifeCycleManager);
        List tmodelList = tModelDetail.getTModel();
        for (TModel tmodel : tmodelList) {
            concept.setKey(lifeCycleManager.createKey(tmodel.getTModelKey()));
            concept.setName(lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(tmodel.getName().getLang()), tmodel.getName().getValue()));
            Description desc = ScoutUddiV3JaxrHelper.getDescription(tmodel);
            if (desc != null) {
                concept.setDescription(lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue()));
            }
            concept.addExternalIdentifiers(ScoutUddiV3JaxrHelper.getExternalIdentifiers(tmodel.getIdentifierBag(), lifeCycleManager));
            concept.addClassifications(ScoutUddiV3JaxrHelper.getClassifications(tmodel.getCategoryBag(), lifeCycleManager));
        }
        return concept;
    }

    public static Concept getConcept(TModel tmodel, LifeCycleManager lifeCycleManager) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lifeCycleManager);
        concept.setKey(lifeCycleManager.createKey(tmodel.getTModelKey()));
        concept.setName(lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(tmodel.getName().getLang()), tmodel.getName().getValue()));
        Description desc = ScoutUddiV3JaxrHelper.getDescription(tmodel);
        if (desc != null) {
            concept.setDescription(lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(desc.getLang()), desc.getValue()));
        }
        concept.addExternalIdentifiers(ScoutUddiV3JaxrHelper.getExternalIdentifiers(tmodel.getIdentifierBag(), lifeCycleManager));
        concept.addClassifications(ScoutUddiV3JaxrHelper.getClassifications(tmodel.getCategoryBag(), lifeCycleManager));
        return concept;
    }

    public static Concept getConcept(TModelInfo tModelInfo, LifeCycleManager lifeCycleManager) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lifeCycleManager);
        concept.setKey(lifeCycleManager.createKey(tModelInfo.getTModelKey()));
        concept.setName(lifeCycleManager.createInternationalString(ScoutUddiV3JaxrHelper.getLocale(tModelInfo.getName().getLang()), tModelInfo.getName().getValue()));
        return concept;
    }

    private static Description getDescription(TModel tmodel) {
        Description desc = null;
        if (tmodel.getDescription().size() > 0) {
            desc = (Description)tmodel.getDescription().get(0);
        }
        return desc;
    }

    public static Collection getClassifications(CategoryBag categoryBag, LifeCycleManager lifeCycleManager) throws JAXRException {
        ArrayList<ClassificationImpl> classifications = null;
        if (categoryBag != null) {
            classifications = new ArrayList<ClassificationImpl>();
            List keyedReferenceList = categoryBag.getKeyedReference();
            for (KeyedReference keyedReference : keyedReferenceList) {
                ClassificationImpl classification = new ClassificationImpl(lifeCycleManager);
                classification.setValue(keyedReference.getKeyValue());
                classification.setName(new InternationalStringImpl(keyedReference.getKeyName()));
                String tmodelKey = keyedReference.getTModelKey();
                if (tmodelKey != null) {
                    ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lifeCycleManager);
                    scheme.setKey(new KeyImpl(tmodelKey));
                    classification.setClassificationScheme(scheme);
                }
                classifications.add(classification);
            }
        }
        return classifications;
    }

    public static Collection<ExternalLink> getExternalLinks(List<OverviewDoc> overviewDocs, LifeCycleManager lifeCycleManager) throws JAXRException {
        ArrayList<ExternalLink> alist = new ArrayList<ExternalLink>();
        if (overviewDocs != null && overviewDocs.size() != 0) {
            for (OverviewDoc overviewDoc : overviewDocs) {
                String descStr = "";
                Description desc = null;
                if (overviewDoc.getDescription().size() > 0) {
                    desc = (Description)overviewDoc.getDescription().get(0);
                }
                if (desc != null) {
                    descStr = desc.getValue();
                }
                alist.add(lifeCycleManager.createExternalLink(overviewDoc.getOverviewURL().getValue().toString(), descStr));
            }
        }
        return alist;
    }

    public static Collection getExternalIdentifiers(IdentifierBag identifierBag, LifeCycleManager lifeCycleManager) throws JAXRException {
        ArrayList<ExternalIdentifierImpl> extidentifiers = null;
        if (identifierBag != null) {
            extidentifiers = new ArrayList<ExternalIdentifierImpl>();
            List keyedReferenceList = identifierBag.getKeyedReference();
            for (KeyedReference keyedReference : keyedReferenceList) {
                ExternalIdentifierImpl extId = new ExternalIdentifierImpl(lifeCycleManager);
                extId.setValue(keyedReference.getKeyValue());
                extId.setName(new InternationalStringImpl(keyedReference.getKeyName()));
                String tmodelKey = keyedReference.getTModelKey();
                if (tmodelKey != null) {
                    ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lifeCycleManager);
                    scheme.setKey(new KeyImpl(tmodelKey));
                    extId.setIdentificationScheme(scheme);
                }
                extidentifiers.add(extId);
            }
        }
        return extidentifiers;
    }

    private static Locale getLocale(String lang) {
        if (lang == null || lang.trim().length() == 0) {
            return Locale.getDefault();
        }
        if (lang.equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        return new Locale(lang);
    }
}

