/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.WriteSkewHelper;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public static final Log log = LogFactory.getLog(ClusteringDependentLogic.class);

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public Address getPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, EntryVersion var2, boolean var3, InvocationContext var4);

    public Collection<Address> getOwners(Collection<Object> var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static final class DistributionLogic
    extends AbstractClusteringDependentLogic {
        private DistributionManager dm;
        private DataContainer dataContainer;
        private Configuration configuration;
        private RpcManager rpcManager;
        private StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return DistributionLogic.this.localNodeIsOwner(key);
            }
        };

        @Inject
        public void init(DistributionManager dm, DataContainer dataContainer, Configuration configuration, RpcManager rpcManager, StateTransferLock stateTransferLock, CacheNotifier notifier) {
            this.dm = dm;
            this.dataContainer = dataContainer;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
            this.stateTransferLock = stateTransferLock;
            this.notifier = notifier;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            return this.dm.getPrimaryLocation(key).equals(address);
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.dm.getPrimaryLocation(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                boolean isForeignOwned;
                boolean doCommit = true;
                boolean bl = isForeignOwned = !skipOwnershipCheck && !this.localNodeIsOwner(entry.getKey());
                if (isForeignOwned && !entry.isRemoved()) {
                    if (this.configuration.clustering().l1().enabled()) {
                        this.dm.transformForL1(entry);
                    } else {
                        doCommit = false;
                    }
                }
                boolean created = false;
                boolean removed = false;
                boolean evicted = false;
                if (!isForeignOwned) {
                    created = entry.isCreated();
                    removed = entry.isRemoved();
                    evicted = entry.isEvicted();
                }
                if (doCommit) {
                    entry.commit(this.dataContainer, newVersion);
                } else {
                    entry.rollback();
                }
                if (!isForeignOwned) {
                    this.notifyCommitEntry(created, removed, evicted, entry, ctx);
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return this.dm.getAffectedNodes(keys);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, this.keySpecificLogic);
            CacheTransaction cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }
    }

    public static final class AllNodesLogic
    extends AbstractClusteringDependentLogic {
        private DataContainer dataContainer;
        private RpcManager rpcManager;
        private static final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return true;
            }
        };

        @Inject
        public void init(DataContainer dc, RpcManager rpcManager, CacheNotifier notifier) {
            this.dataContainer = dc;
            this.rpcManager = rpcManager;
            this.notifier = notifier;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.rpcManager == null || this.rpcManager.getTransport().isCoordinator();
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            if (this.rpcManager == null) {
                throw new IllegalStateException("Cannot invoke this method for local caches");
            }
            return this.rpcManager.getTransport().getCoordinator();
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean evicted = entry.isEvicted();
            entry.commit(this.dataContainer, newVersion);
            this.notifyCommitEntry(created, removed, evicted, entry, ctx);
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (this.rpcManager.getTransport().isCoordinator()) {
                EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, keySpecificLogic);
                context.getCacheTransaction().setUpdatedEntryVersions(uv);
                return uv;
            }
            if (prepareCommand.getModifications().length == 0) {
                context.getCacheTransaction().setUpdatedEntryVersions(new EntryVersionsMap());
            }
            return null;
        }
    }

    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        protected CacheNotifier notifier;

        protected void notifyCommitEntry(boolean created, boolean removed, boolean evicted, CacheEntry entry, InvocationContext ctx) {
            if (removed && evicted) {
                this.notifier.notifyCacheEntryEvicted(entry.getKey(), entry.getValue(), ctx);
            } else if (removed) {
                this.notifier.notifyCacheEntryRemoved(entry.getKey(), null, false, ctx);
            } else {
                this.notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), false, ctx);
                if (created) {
                    this.notifier.notifyCacheEntryCreated(entry.getKey(), false, ctx);
                }
            }
        }
    }
}

