/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryWrappingInterceptor
extends CommandInterceptor {
    private EntryFactory entryFactory;
    protected DataContainer dataContainer;
    protected ClusteringDependentLogic cdl;
    protected final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private CommandsFactory commandFactory;
    private boolean isUsingLockDelegation;
    private StateConsumer stateConsumer;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(EntryFactory entryFactory, DataContainer dataContainer, ClusteringDependentLogic cdl, CommandsFactory commandFactory, StateConsumer stateConsumer) {
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
        this.commandFactory = commandFactory;
        this.stateConsumer = stateConsumer;
    }

    @Start
    public void start() {
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional() && this.cacheConfiguration.locking().supportsConcurrentUpdates() && this.cacheConfiguration.clustering().cacheMode().isDistributed();
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(ctx, this.entryWrappingVisitor);
            }
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.commitContextEntries(ctx, false, this.isFromStateTransfer(ctx));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.commitContextEntries(ctx, false, this.isFromStateTransfer(ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.commitContextEntries(ctx, command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK), false);
            }
        }
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForRemove(ctx, key);
            }
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        for (InternalCacheEntry entry : this.dataContainer.entrySet()) {
            this.entryFactory.wrapEntryForClear(ctx, entry.getKey());
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForRemove(ctx, key);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", ctx.getLookedUpEntries());
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent(), command);
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    private boolean shouldWrap(Object key, InvocationContext ctx, FlagAffectedCommand command) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            log.tracef("Skipping ownership check and wrapping key %s", key);
            return true;
        }
        boolean result = this.cacheConfiguration.transaction().transactionMode().isTransactional() ? true : (this.isUsingLockDelegation ? this.cdl.localNodeIsPrimaryOwner(key) || this.cdl.localNodeIsOwner(key) && !ctx.isOriginLocal() : this.cdl.localNodeIsOwner(key));
        log.tracef("Wrapping entry '%s'? %s", key, result);
        return result;
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.entryFactory.wrapEntryForDelta(ctx, command.getDeltaAwareKey(), command.getDelta());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public final Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            this.entryFactory.wrapEntryForRemove(ctx, command.getKey());
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            this.entryFactory.wrapEntryForReplace(ctx, command.getKey());
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object key : command.getMap().keySet()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForPut(ctx, key, null, true, command);
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.visitRemoveCommand(ctx, command);
    }

    protected boolean isFromStateTransfer(InvocationContext ctx) {
        LocalTransaction localTx;
        return ctx.isInTxScope() && ctx.isOriginLocal() && (localTx = (LocalTransaction)((TxInvocationContext)ctx).getCacheTransaction()).isFromStateTransfer();
    }

    protected boolean isFromStateTransfer(FlagAffectedCommand command) {
        return command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER);
    }

    protected final void commitContextEntries(InvocationContext ctx, boolean skipOwnershipCheck, boolean isPutForStateTransfer) {
        if (!isPutForStateTransfer && this.stateConsumer != null && ctx instanceof TxInvocationContext && ((TxInvocationContext)ctx).getCacheTransaction().hasModification(ClearCommand.class)) {
            this.stateConsumer.stopApplyingState();
        }
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            this.commitEntryIfNeeded(ctx, skipOwnershipCheck, singleKeyCtx.getKey(), singleKeyCtx.getCacheEntry(), isPutForStateTransfer);
        } else {
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.iterator();
            Log log = this.getLog();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (this.commitEntryIfNeeded(ctx, skipOwnershipCheck, e.getKey(), entry, isPutForStateTransfer) || !trace) continue;
                if (entry == null) {
                    log.tracef("Entry for key %s is null : not calling commitUpdate", e.getKey());
                    continue;
                }
                log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", e.getKey(), entry);
            }
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, boolean skipOwnershipCheck) {
        this.cdl.commitEntry(entry, null, skipOwnershipCheck, ctx);
    }

    private Object invokeNextAndApplyChanges(InvocationContext ctx, FlagAffectedCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isInTxScope()) {
            this.commitContextEntries(ctx, command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK), this.isFromStateTransfer(command));
        }
        log.tracef("The return value is %s", result);
        return result;
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, boolean skipOwnershipCheck, Object key, CacheEntry entry, boolean isPutForStateTransfer) {
        if (entry == null) {
            if (key != null && !isPutForStateTransfer && this.stateConsumer != null) {
                this.stateConsumer.addUpdatedKey(key);
            }
            return false;
        }
        if (isPutForStateTransfer && this.stateConsumer.isKeyUpdated(key)) {
            log.tracef("State transfer will not write key/value %s/%s because it was already updated by somebody else", key, entry.getValue());
            entry.rollback();
            return false;
        }
        if (entry.isChanged() || entry.isLoaded()) {
            log.tracef("About to commit entry %s", entry);
            this.commitContextEntry(entry, ctx, skipOwnershipCheck);
            if (!isPutForStateTransfer && this.stateConsumer != null) {
                this.stateConsumer.addUpdatedKey(key);
            }
            return true;
        }
        return false;
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            boolean wrapped = false;
            for (Object key : EntryWrappingInterceptor.this.dataContainer.keySet()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForClear(ctx, key);
                wrapped = true;
            }
            if (wrapped) {
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            if (EntryWrappingInterceptor.this.stateConsumer != null && !ctx.isInTxScope()) {
                EntryWrappingInterceptor.this.stateConsumer.stopApplyingState();
            }
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>(4);
            for (Map.Entry<Object, Object> e : command.getMap().entrySet()) {
                Object key = e.getKey();
                if (!EntryWrappingInterceptor.this.cdl.localNodeIsOwner(key)) continue;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, key, null, true, command);
                newMap.put(key, e.getValue());
            }
            if (newMap.size() > 0) {
                PutMapCommand clonedCommand = EntryWrappingInterceptor.this.commandFactory.buildPutMapCommand(newMap, command.getLifespanMillis(), command.getMaxIdleTimeMillis(), command.getFlags());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, clonedCommand);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForRemove(ctx, command.getKey());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent(), command);
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForDelta(ctx, command.getDeltaAwareKey(), command.getDelta());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForReplace(ctx, command.getKey());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }
    }
}

