/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;

public class Status
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Check status of RHQ storage node").addOption(null, "server", false, "Check status of RHQ server").addOption(null, "agent", false, "Check status of RHQ agent");

    @Override
    public String getName() {
        return "status";
    }

    @Override
    public String getDescription() {
        return "Check status of RHQ services";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "STATUS_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue = 0;
        try {
            boolean isColorSupported = Boolean.parseBoolean(System.getProperty("color"));
            if (commandLine.getOptions().length == 0) {
                if (this.isStorageInstalled()) {
                    rValue = Math.max(rValue, this.checkStorageStatus(isColorSupported));
                }
                if (this.isServerInstalled()) {
                    rValue = Math.max(rValue, this.checkServerStatus());
                }
                if (this.isAgentInstalled()) {
                    rValue = Math.max(rValue, this.checkAgentStatus());
                }
            } else {
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        rValue = Math.max(rValue, this.checkStorageStatus(isColorSupported));
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        rValue = Math.max(rValue, this.checkServerStatus());
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        rValue = Math.max(rValue, this.checkAgentStatus());
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to check statuses", e);
        }
        return rValue;
    }

    private int checkStorageStatus(boolean isColorSupported) throws Exception {
        this.log.debug((Object)"Checking RHQ storage node status");
        int rValue = 0;
        if (this.isWindows()) {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            executor.setWorkingDirectory(this.getBinDir());
            CommandLine commandLine = this.getCommandLine("rhq-storage", "status");
            try {
                rValue = executor.execute(commandLine);
            }
            catch (ExecuteException ee) {
                this.log.debug((Object)"Failed to check storage service status", (Throwable)ee);
                rValue = ee.getExitValue();
                if (rValue == 0) {
                    rValue = 4;
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to check storage service status", (Throwable)e);
                rValue = 4;
            }
        } else {
            String ANSI_RED = "\u001b[31m";
            String ANSI_GREEN = "\u001b[32m";
            String ANSI_RESET = "\u001b[0m";
            if (this.isStorageRunning()) {
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (pid " + String.format("%-7s", this.getStoragePid()) + ") is " + (isColorSupported ? "\u001b[32m" : "") + "\u2714running" + (isColorSupported ? "\u001b[0m" : ""));
            } else {
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (no pid file) is " + (isColorSupported ? "\u001b[31m" : "") + "\u2718down" + (isColorSupported ? "\u001b[0m" : ""));
                rValue = 3;
            }
        }
        return rValue;
    }

    private int checkServerStatus() throws Exception {
        int rValue;
        block2: {
            this.log.debug((Object)"Checking RHQ server status");
            CommandLine commandLine = this.getCommandLine("rhq-server", "status");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            try {
                rValue = executor.execute(commandLine);
            }
            catch (ExecuteException ee) {
                rValue = ee.getExitValue();
                if (rValue != 0) break block2;
                rValue = 4;
            }
        }
        return rValue;
    }

    private int checkAgentStatus() throws Exception {
        int rValue;
        block3: {
            this.log.debug((Object)"Checking RHQ agent status");
            File agentBinDir = new File(this.getAgentBasedir(), "bin");
            CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "status");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(agentBinDir);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            try {
                rValue = executor.execute(commandLine);
            }
            catch (ExecuteException e) {
                if (!this.isWindows() && e.getExitValue() != 1) {
                    throw e;
                }
                rValue = e.getExitValue();
                if (rValue != 0) break block3;
                rValue = 4;
            }
        }
        return rValue;
    }
}

