/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.command.Console;
import org.rhq.server.control.command.Install;
import org.rhq.server.control.command.Remove;
import org.rhq.server.control.command.Restart;
import org.rhq.server.control.command.Start;
import org.rhq.server.control.command.Status;
import org.rhq.server.control.command.Stop;
import org.rhq.server.control.command.Upgrade;

public class Commands {
    private Map<String, ControlCommand> commands = new TreeMap<String, ControlCommand>(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    });

    public Commands() {
        this.registerCommand(new Install());
        this.registerCommand(new Start());
        this.registerCommand(new Stop());
        this.registerCommand(new Restart());
        this.registerCommand(new Status());
        this.registerCommand(new Console());
        if (File.separatorChar == '\\') {
            this.registerCommand(new Remove());
        }
        this.registerCommand(new Upgrade());
    }

    private void registerCommand(ControlCommand command) {
        this.commands.put(command.getName(), command);
    }

    public Options getOptions() {
        Options options = new Options();
        for (ControlCommand cmd : this.commands.values()) {
            if (cmd.getOptions().getOptions().isEmpty()) {
                OptionBuilder.withDescription((String)cmd.getDescription());
                options.addOption(OptionBuilder.create((String)cmd.getName()));
                continue;
            }
            if (cmd.getOptions().getOptions().size() == 1) {
                OptionBuilder.withArgName((String)"[options]");
                OptionBuilder.hasOptionalArg();
                OptionBuilder.withDescription((String)cmd.getDescription());
                options.addOption(OptionBuilder.create((String)cmd.getName()));
                continue;
            }
            OptionBuilder.withArgName((String)"[options]");
            OptionBuilder.hasOptionalArgs();
            OptionBuilder.withDescription((String)cmd.getDescription());
            options.addOption(OptionBuilder.create((String)cmd.getName()));
        }
        return options;
    }

    public ControlCommand get(String name) {
        return this.commands.get(name);
    }

    public boolean contains(String name) {
        return this.commands.containsKey(name);
    }
}

