/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ListPropertySimpleWrapper;
import org.rhq.core.pluginapi.configuration.MapPropertySimpleWrapper;

public class StartScriptConfiguration {
    public static final String START_SCRIPT_PROP = "startScript";
    public static final String START_SCRIPT_PREFIX_PROP = "startScriptPrefix";
    public static final String START_SCRIPT_ENV_PROP = "startScriptEnv";
    public static final String START_SCRIPT_ARGS_PROP = "startScriptArgs";
    private final Log log = LogFactory.getLog(this.getClass());
    private Configuration pluginConfig;

    public StartScriptConfiguration(Configuration pluginConfig) {
        if (pluginConfig == null) {
            throw new IllegalArgumentException("'pluginConfig' parameter is null.");
        }
        this.pluginConfig = pluginConfig;
    }

    @Nullable
    public File getStartScript() {
        String startScript = this.pluginConfig.getSimpleValue(START_SCRIPT_PROP);
        return startScript != null ? new File(startScript) : null;
    }

    public void setStartScript(File startScript) {
        PropertySimple prop = this.pluginConfig.getSimple(START_SCRIPT_PROP);
        if (prop == null) {
            prop = new PropertySimple(START_SCRIPT_PROP, null);
            this.pluginConfig.put((Property)prop);
        }
        prop.setValue((Object)startScript);
    }

    @Nullable
    public String getStartScriptPrefix() {
        return this.pluginConfig.getSimpleValue(START_SCRIPT_PREFIX_PROP);
    }

    public void setStartScriptPrefix(String startScriptPrefix) {
        this.pluginConfig.setSimpleValue(START_SCRIPT_PREFIX_PROP, startScriptPrefix);
    }

    @NotNull
    public Map<String, String> getStartScriptEnv() {
        PropertySimple prop = this.pluginConfig.getSimple(START_SCRIPT_ENV_PROP);
        HashMap<String, String> map = prop != null ? new MapPropertySimpleWrapper(prop).getValue() : new HashMap<String, String>();
        return map;
    }

    public void setStartScriptEnv(Map<String, String> startScriptEnv) {
        PropertySimple prop = this.pluginConfig.getSimple(START_SCRIPT_ENV_PROP);
        if (prop == null) {
            prop = new PropertySimple(START_SCRIPT_ENV_PROP, null);
            this.pluginConfig.put((Property)prop);
        }
        try {
            new MapPropertySimpleWrapper(prop).setValue(startScriptEnv);
        }
        catch (IllegalArgumentException e) {
            this.setPropertyError(startScriptEnv, prop);
        }
    }

    @NotNull
    public List<String> getStartScriptArgs() {
        PropertySimple prop = this.pluginConfig.getSimple(START_SCRIPT_ARGS_PROP);
        ArrayList<String> list = prop != null ? new ArgsPropertySimpleWrapper(prop).getValue() : new ArrayList<String>();
        return list;
    }

    public void setStartScriptArgs(List<String> startScriptArgs) {
        PropertySimple prop = this.pluginConfig.getSimple(START_SCRIPT_ARGS_PROP);
        if (prop == null) {
            prop = new PropertySimple(START_SCRIPT_ARGS_PROP, null);
            this.pluginConfig.put((Property)prop);
        }
        try {
            new ArgsPropertySimpleWrapper(prop).setValue(startScriptArgs);
        }
        catch (IllegalArgumentException e) {
            this.setPropertyError(startScriptArgs, prop);
        }
    }

    private void setPropertyError(Object rawPropValue, PropertySimple prop) {
        prop.setErrorMessage("The discovered value of this property was longer than 2000 characters (the maximum length of an RHQ property). It has been left unset.  Please see the Agent log for the full value.");
        this.log.warn((Object)("The discovered value for property [" + prop.getName() + "] was too long and was left unset. It is logged here for reference: " + rawPropValue));
    }

    public Configuration getPluginConfig() {
        return this.pluginConfig;
    }

    private static class ArgsPropertySimpleWrapper
    extends ListPropertySimpleWrapper {
        public ArgsPropertySimpleWrapper(PropertySimple prop) {
            super(prop);
        }

        @Override
        public void setValue(List list) {
            String stringValue;
            if (list != null && !list.isEmpty()) {
                StringBuilder buffer = new StringBuilder(list.get(0).toString());
                for (int i = 1; i < list.size(); ++i) {
                    String arg = list.get(i).toString();
                    buffer.append(arg.startsWith("-") ? (char)'\n' : ' ').append(arg);
                }
                stringValue = buffer.toString();
            } else {
                stringValue = null;
            }
            if (null != stringValue && stringValue.length() > 2000) {
                throw new IllegalArgumentException(stringValue);
            }
            this.prop.setStringValue(stringValue);
        }

        @Override
        public List<String> getValue() {
            ArrayList<String> list = new ArrayList<String>();
            String stringValue = this.prop.getStringValue();
            if (stringValue != null) {
                String[] lines;
                for (String line : lines = stringValue.split("\n+")) {
                    String element = line.trim();
                    if (element.startsWith("-")) {
                        boolean added = false;
                        int len = element.length();
                        for (int i = 1; i < len; ++i) {
                            char ch = element.charAt(i);
                            if (ch != ' ' && ch != '\t') continue;
                            String option = element.substring(0, i);
                            String value = element.substring(i).trim();
                            list.add(option);
                            if (!value.isEmpty()) {
                                list.add(value);
                            }
                            added = true;
                            break;
                        }
                        if (added) continue;
                        list.add(element);
                        continue;
                    }
                    list.add(element);
                }
            }
            return list;
        }
    }
}

