/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.event.Event;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileInfo;

public class LogFileEventPoller
implements EventPoller {
    private static final Log LOG = LogFactory.getLog(LogFileEventPoller.class);
    private String eventType;
    private File logFile;
    private FileInfo logFileInfo;
    private LogEntryProcessor entryProcessor;
    private EventContext eventContext;
    private boolean initialized;

    public LogFileEventPoller(EventContext eventContext, String eventType, File logFile, LogEntryProcessor entryProcessor) {
        this.eventType = eventType;
        this.logFile = logFile;
        this.entryProcessor = entryProcessor;
        this.eventContext = eventContext;
    }

    @Override
    @NotNull
    public String getEventType() {
        return this.eventType;
    }

    @NotNull
    public String getSourceLocation() {
        return this.logFile.getPath();
    }

    @Override
    @Nullable
    public Set<Event> poll() {
        if (!this.logFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Log file [" + this.logFile + "] being polled does not exist."));
            }
            return null;
        }
        if (this.logFile.isDirectory()) {
            LOG.error((Object)("Log file [" + this.logFile + "] being polled is a directory, not a regular file."));
            return null;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.logFileInfo == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot poll log file [" + this.logFile + "] because native integration is either disabled or unavailable."));
            }
            return null;
        }
        try {
            if (!this.logFileInfo.changed()) {
                return null;
            }
        }
        catch (SigarException e) {
            throw new RuntimeException(e);
        }
        return this.processNewLines(this.logFileInfo);
    }

    protected void init() {
        SigarProxy sigar = this.eventContext.getSigar();
        if (sigar != null) {
            try {
                this.logFileInfo = new LogFileInfo(sigar.getFileInfo(this.logFile.getPath()));
            }
            catch (SigarException e) {
                throw new RuntimeException("Failed to obtain file info for log file [" + this.logFile + "].", e);
            }
        } else {
            LOG.warn((Object)("SIGAR is unavailable - cannot poll log file [" + this.logFile + "] for events."));
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Event> processNewLines(FileInfo fileInfo) {
        Set<Event> events = null;
        FileReader reader = null;
        try {
            reader = new FileReader(this.logFile);
            long offset = this.getOffset(fileInfo);
            if (offset > 0L) {
                reader.skip(offset);
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            events = this.entryProcessor.processLines(bufferedReader);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to read log file being tailed: " + this.logFile), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
        return events;
    }

    private long getOffset(FileInfo fileInfo) {
        FileInfo previousFileInfo = fileInfo.getPreviousInfo();
        if (previousFileInfo == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.logFile + ": first stat"));
            }
            return fileInfo.getSize();
        }
        if (fileInfo.getInode() != previousFileInfo.getInode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.logFile + ": file inode changed"));
            }
            return -1L;
        }
        if (fileInfo.getSize() < previousFileInfo.getSize()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.logFile + ": file truncated"));
            }
            return -1L;
        }
        if (LOG.isDebugEnabled()) {
            long diff = fileInfo.getSize() - previousFileInfo.getSize();
            LOG.debug((Object)(this.logFile + ": " + diff + " new bytes"));
        }
        return previousFileInfo.getSize();
    }
}

