/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.weld.SecurityActions;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.as.weld.services.bootstrap.WeldResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.services.bootstrap.WeldTransactionServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;

public class WeldBootstrapService
implements Service<WeldBootstrapService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldBootstrapService"});
    private final WeldBootstrap bootstrap;
    private final WeldDeployment deployment;
    private final Environment environment;
    private final Map<String, BeanDeploymentArchive> beanDeploymentArchives;
    private final String deploymentName;
    private final InjectedValue<WeldResourceInjectionServices> resourceInjectionServices = new InjectedValue();
    private final InjectedValue<WeldSecurityServices> securityServices = new InjectedValue();
    private final InjectedValue<WeldTransactionServices> weldTransactionServices = new InjectedValue();
    private volatile boolean started;

    public WeldBootstrapService(WeldDeployment deployment, Environment environment, String deploymentName) {
        this.deployment = deployment;
        this.environment = environment;
        this.deploymentName = deploymentName;
        this.bootstrap = new WeldBootstrap();
        HashMap<String, BeanDeploymentArchive> bdas = new HashMap<String, BeanDeploymentArchive>();
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            bdas.put(archive.getId(), archive);
        }
        bdas.put(deployment.getAdditionalBeanDeploymentArchive().getId(), deployment.getAdditionalBeanDeploymentArchive());
        this.beanDeploymentArchives = Collections.unmodifiableMap(bdas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) {
        if (this.started) {
            throw WeldMessages.MESSAGES.alreadyRunning("WeldContainer");
        }
        this.started = true;
        WeldLogger.DEPLOYMENT_LOGGER.startingWeldService(this.deploymentName);
        this.addWeldService(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)this.securityServices.getValue());
        this.addWeldService(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)this.weldTransactionServices.getValue());
        for (BeanDeploymentArchive bda : this.getBeanDeploymentArchives()) {
            bda.getServices().add(ResourceInjectionServices.class, (org.jboss.weld.bootstrap.api.Service)this.resourceInjectionServices.getValue());
        }
        ModuleGroupSingletonProvider.addClassLoaders((ClassLoader)this.deployment.getModule().getClassLoader(), this.deployment.getSubDeploymentClassLoaders());
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.startContainer(this.environment, (Deployment)this.deployment);
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        if (!this.started) {
            throw WeldMessages.MESSAGES.notStarted("WeldContainer");
        }
        WeldLogger.DEPLOYMENT_LOGGER.stoppingWeldService(this.deploymentName);
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.shutdown();
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
            ModuleGroupSingletonProvider.removeClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
        }
        this.started = false;
    }

    public BeanManager getBeanManager(String beanArchiveId) {
        if (!this.started) {
            throw WeldMessages.MESSAGES.notStarted("WeldContainer");
        }
        BeanDeploymentArchive beanDeploymentArchive = this.beanDeploymentArchives.get(beanArchiveId);
        if (beanDeploymentArchive == null) {
            throw WeldMessages.MESSAGES.beanDeploymentNotFound(beanArchiveId);
        }
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public <T extends org.jboss.weld.bootstrap.api.Service> void addWeldService(Class<T> type, T service) {
        this.deployment.getServices().add(type, service);
        this.deployment.getAdditionalBeanDeploymentArchive().getServices().add(type, service);
    }

    public BeanManager getBeanManager() {
        if (!this.started) {
            throw WeldMessages.MESSAGES.notStarted("WeldContainer");
        }
        return this.bootstrap.getManager((BeanDeploymentArchive)this.deployment.getAdditionalBeanDeploymentArchive());
    }

    public Set<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives.values());
    }

    public boolean isStarted() {
        return this.started;
    }

    WeldBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public WeldBootstrapService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldResourceInjectionServices> getResourceInjectionServices() {
        return this.resourceInjectionServices;
    }

    public InjectedValue<WeldSecurityServices> getSecurityServices() {
        return this.securityServices;
    }

    public InjectedValue<WeldTransactionServices> getWeldTransactionServices() {
        return this.weldTransactionServices;
    }
}

