/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlUserComponent
implements MeasurementFacet,
DatabaseComponent,
ConnectionPoolingSupport {
    private static final Log LOG = LogFactory.getLog(MySqlUserComponent.class);
    private String userName;
    private String host;
    private MySqlComponent parent;
    private ResourceContext resourceContext;

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.parent.getPooledConnectionProvider();
    }

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.parent = (MySqlComponent)resourceContext.getParentResourceComponent();
        this.resourceContext = resourceContext;
        this.userName = this.resourceContext.getPluginConfiguration().getSimple("userName").getStringValue();
        this.host = this.resourceContext.getPluginConfiguration().getSimple("host").getStringValue();
    }

    public void stop() {
        this.parent = null;
        this.resourceContext = null;
        this.userName = null;
        this.host = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getValues(MeasurementReport mr, Set<MeasurementScheduleRequest> requests) throws Exception {
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int activeConnections = 0;
        int totalConnections = 0;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("select User,Host,State from information_schema.processlist where User='" + this.userName + "'");
            while (resultSet.next()) {
                String hostVal = resultSet.getString(2);
                String state = resultSet.getString(3);
                if (!hostVal.startsWith(this.host)) continue;
                if (state.length() > 1) {
                    ++activeConnections;
                }
                ++totalConnections;
            }
        }
        catch (SQLException ignore) {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("TotalConnections")) {
                mr.addData(new MeasurementDataNumeric(request, new Double(totalConnections)));
                continue;
            }
            if (!request.getName().equals("ActiveConnections")) continue;
            mr.addData(new MeasurementDataNumeric(request, new Double(activeConnections)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Statement statement;
        ResultSet resultSet;
        Connection jdbcConnection;
        block4: {
            AvailabilityType availabilityType;
            jdbcConnection = null;
            resultSet = null;
            statement = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = jdbcConnection.createStatement();
                resultSet = statement.executeQuery("select User from mysql.user where User='" + this.userName + "' and Host='" + this.host + "'");
                if (!resultSet.first()) break block4;
                availabilityType = AvailabilityType.UP;
            }
            catch (SQLException sqle) {
                try {
                    System.out.println("sqle = " + sqle);
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                    throw throwable;
                }
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            return availabilityType;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return AvailabilityType.DOWN;
    }
}

