/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssJbnDependency;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl090;
import churchillobjects.rss4j.generator.RssGeneratorImpl091;
import churchillobjects.rss4j.generator.RssGeneratorImpl100;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class RssGenerator {
    protected DOMImplementation domImpl;
    protected OutputFormat format;
    protected Document doc;
    protected Writer outputWriter;
    protected OutputStream outputStream;
    protected Element rootElement;
    private boolean truncateText = false;
    protected int channelTitleMax;
    protected int channelDescriptionMax;
    protected int channelLinkMax;
    protected int channelPubDate;
    protected int channelBuildDate;
    protected int channelManagingEditorMax;
    protected int channelWebmasterMax;
    protected int channelCopyrightMax;
    protected int channelDocsMax;
    protected int imageTitleMax;
    protected int imageUrlMax;
    protected int imageLinkMax;
    protected int imageDescriptionMax;
    protected int itemTitleMax;
    protected int itemLinkMax;
    protected int itemDescriptionMax;
    protected int textInputTitleMax;
    protected int textInputDescriptionMax;
    protected int textInputNameMax;
    protected int textInputLinkMax;

    public static String generateRss(RssDocument document) throws RssGenerationException {
        StringWriter sw = new StringWriter();
        RssGenerator.generateRss(document, sw);
        return sw.toString();
    }

    public static void generateRss(RssDocument document, OutputStream output) throws RssGenerationException {
        RssGenerator generator = RssGenerator.getGenerator(document);
        generator.writeRssDocument(document, output);
    }

    public static void generateRss(RssDocument document, File file) throws RssGenerationException {
        RssGenerator generator = RssGenerator.getGenerator(document);
        generator.writeRssDocument(document, file);
    }

    public static void generateRss(RssDocument document, Writer output) throws RssGenerationException {
        RssGenerator generator = RssGenerator.getGenerator(document);
        generator.writeRssDocument(document, output);
    }

    private static RssGenerator getGenerator(RssDocument document) throws RssGenerationException {
        String version = document.getVersion();
        if (version == null || version.length() == 0) {
            throw new RssGenerationException("RSS version was not specified in the RssDocument object.");
        }
        if ("0.90".equals(version)) {
            return new RssGeneratorImpl090();
        }
        if ("0.91".equals(version)) {
            return new RssGeneratorImpl091();
        }
        if ("1.0".equals(version)) {
            return new RssGeneratorImpl100();
        }
        throw new RssGenerationException("Could not find a generator for the document version: " + version);
    }

    RssGenerator() throws RssGenerationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.domImpl = builder.getDOMImplementation();
            this.format = new OutputFormat();
            this.format.setLineWidth(65);
            this.format.setIndenting(true);
            this.format.setIndent(2);
            this.format.setEncoding("UTF-8");
            this.format.setMediaType("application/xml");
            this.format.setOmitComments(true);
            this.format.setOmitXMLDeclaration(false);
            this.format.setVersion("1.0");
            this.format.setStandalone(true);
        }
        catch (ParserConfigurationException e) {
            throw new RssGenerationException("Could not locate a JAXP DocumentBuilder class");
        }
        this.setMaxLengths();
    }

    protected abstract void setMaxLengths();

    protected abstract void handleChannel(RssChannel var1) throws RssGenerationException;

    protected abstract void finishDocument() throws RssGenerationException;

    private void writeRssDocument(RssDocument data) throws RssGenerationException {
        try {
            this.createRssDocument(data);
            Enumeration channels = data.channels();
            while (channels.hasMoreElements()) {
                RssChannel channel = (RssChannel)channels.nextElement();
                if (channel == null) continue;
                this.handleChannel(channel);
            }
            this.finishDocument();
            XMLSerializer serializer = null;
            serializer = this.outputWriter != null ? new XMLSerializer(this.outputWriter, this.format) : new XMLSerializer(this.outputStream, this.format);
            serializer.serialize(this.doc);
        }
        catch (FactoryConfigurationError e) {
            throw new RssGenerationException("Could not locate a JAXP factory class");
        }
        catch (DOMException e) {
            throw new RssGenerationException(e);
        }
        catch (IOException e) {
            throw new RssGenerationException(e);
        }
    }

    protected abstract void createRssDocument(RssDocument var1) throws RssGenerationException;

    private void writeRssDocument(RssDocument data, OutputStream output) throws RssGenerationException {
        this.outputStream = output;
        this.writeRssDocument(data);
    }

    private void writeRssDocument(RssDocument data, File file) throws RssGenerationException {
        try {
            this.outputStream = new FileOutputStream(file);
            this.writeRssDocument(data);
        }
        catch (IOException e) {
            throw new RssGenerationException(e);
        }
    }

    private void writeRssDocument(RssDocument data, Writer output) throws RssGenerationException {
        this.outputWriter = output;
        this.writeRssDocument(data);
    }

    protected Element add(Element baseElement, String nodeName, String textValue) {
        if (textValue != null) {
            Element attrib = this.doc.createElement(nodeName);
            Text chars = this.doc.createTextNode(textValue);
            attrib.appendChild(chars);
            baseElement.appendChild(attrib);
            return attrib;
        }
        return null;
    }

    protected Element add(Element baseElement, String outerNodeName, String attributeName, String attributeValue, String innerNodeName, Collection innerNodeValues) {
        if (attributeValue != null || innerNodeValues != null) {
            Element outerNode = this.doc.createElement(outerNodeName);
            if (attributeValue != null) {
                outerNode.setAttribute(attributeName, attributeValue);
            }
            if (innerNodeValues != null) {
                Iterator innerValues = innerNodeValues.iterator();
                while (innerValues.hasNext()) {
                    Element innerNode = this.doc.createElement(innerNodeName);
                    Text chars = this.doc.createTextNode((String)innerValues.next());
                    innerNode.appendChild(chars);
                    outerNode.appendChild(innerNode);
                }
            }
            baseElement.appendChild(outerNode);
        }
        return baseElement;
    }

    protected Element add(Element baseElement, String outerNodeName, String innerNodeName, String innerNodeAttributeName, Collection dependencies) {
        if (innerNodeName != null && dependencies != null) {
            Element outerNode = this.doc.createElement(outerNodeName);
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                Element innerNode = this.doc.createElement(innerNodeName);
                RssJbnDependency dependency = (RssJbnDependency)iterator.next();
                if (innerNodeAttributeName != null && dependency != null) {
                    innerNode.setAttribute(innerNodeAttributeName, dependency.getUrl());
                }
                Text chars = this.doc.createTextNode(dependency.getName());
                innerNode.appendChild(chars);
                outerNode.appendChild(innerNode);
            }
            baseElement.appendChild(outerNode);
        }
        return baseElement;
    }

    protected Element add(Element baseElement, String outerNodeName, String innerNodeName, Collection dependencies) {
        Element outerNode = this.doc.createElement(outerNodeName);
        if (innerNodeName != null && dependencies != null) {
            Iterator dependencyIterator = dependencies.iterator();
            while (dependencyIterator.hasNext()) {
                RssJbnDependency rjd = (RssJbnDependency)dependencyIterator.next();
                HashMap<String, String> nameValuePair = new HashMap<String, String>();
                nameValuePair.put("rdf:about", rjd.getUrl());
                nameValuePair.put("jbn:productName", rjd.getProductName());
                nameValuePair.put("jbn:productVersion", rjd.getProductVersion());
                nameValuePair.put("jbn:jonResourceType", rjd.getJonResourceType());
                nameValuePair.put("jbn:jonResourceVersion", rjd.getJonResourceVersion());
                outerNode.appendChild(this.add("jbn:product", nameValuePair, rjd.getName()));
            }
            baseElement.appendChild(outerNode);
        }
        return baseElement;
    }

    private Element add(String innerNodeName, Map attributeNameValuePairs, String content) {
        Element innerNode = this.doc.createElement(innerNodeName);
        Iterator keyIterator = attributeNameValuePairs.keySet().iterator();
        while (keyIterator.hasNext()) {
            String name = (String)keyIterator.next();
            String value = (String)attributeNameValuePairs.get(name);
            innerNode.setAttribute(name, value);
        }
        Text chars = this.doc.createTextNode(content);
        innerNode.appendChild(chars);
        return innerNode;
    }

    public void setTruncateText(boolean b) {
        this.truncateText = b;
    }

    public boolean isTruncateText() {
        return this.truncateText;
    }

    protected String truncate(String s, int length) throws RssGenerationException {
        if (!this.truncateText || s == null || length == 0) {
            return s;
        }
        if ((s = s.trim()).length() <= length) {
            return s;
        }
        s = s.substring(0, length - 3).trim();
        return s + "...";
    }

    protected void validateValueRequired(String value, String name, int minLength, int maxLength) throws RssGenerationException {
        if (value == null || value.length() == 0) {
            throw new RssGenerationException(name + " attribute required");
        }
        if (value == null || value.length() == 0 || maxLength > 0 && value.length() > maxLength) {
            throw new RssGenerationException(name + " attribute must be between " + minLength + " and " + maxLength + " characters: " + value.length() + " '" + value + "'");
        }
    }

    protected void validateValueRequired(String value, String name, int maxLength) throws RssGenerationException {
        this.validateValueRequired(value, name, 1, maxLength);
    }

    protected void validateValueOptional(String value, String name, int minLength, int maxLength) throws RssGenerationException {
        if (maxLength > 0 && value != null && value.length() > maxLength) {
            throw new RssGenerationException(name + " optional, but length must be between " + minLength + " and " + maxLength + " characters: " + value.length() + " '" + value + "'");
        }
    }

    protected void validateValueOptional(String value, String name, int maxLength) throws RssGenerationException {
        this.validateValueOptional(value, name, 1, maxLength);
    }

    protected String embedHtml(String s) {
        if (s.indexOf("<") >= 0) {
            s = "<[!CDATA[" + s + "]]>";
        }
        return s;
    }

    protected void validateUri(String s) throws RssGenerationException {
        if (!(s == null || s.length() <= 0 || s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:") || s.startsWith("mailto:"))) {
            throw new RssGenerationException("Invalid URI format: must be 'http:', 'https:', 'ftp:', or 'mailto:' - " + s);
        }
    }
}

