/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j;

import churchillobjects.rss4j.model.DateLanguageUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;

public class RssSyndication
implements Cloneable,
Serializable {
    public static final String XMLNS = "xmlns:sy";
    public static final String PREFIX = "sy";
    public static final String XMLNS_VALUE = "http://purl.org/rss/1.0/modules/syndication/";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    public static final String YEARLY = "yearly";
    private String updatePeriod = "daily";
    private int updateFrequency = 1;
    private String updateBase;
    private Date updateBaseDate;

    public RssSyndication() {
    }

    public RssSyndication(String updatePeriod, int updateFrequency, String updateBase) throws ParseException {
        this.setUpdateBase(updateBase);
        this.setUpdatePeriod(updatePeriod);
        this.updateFrequency = updateFrequency;
    }

    public RssSyndication(String updatePeriod, int updateFrequency, Date updateBase) {
        this.setUpdateBase(updateBase);
        this.setUpdatePeriod(updatePeriod);
        this.updateFrequency = updateFrequency;
    }

    public void setUpdateBase(String s) throws ParseException {
        this.updateBaseDate = DateLanguageUtil.convert8601ToDate(s);
        this.updateBase = s;
    }

    public void setUpdateBase(Date date) {
        this.updateBaseDate = date;
        this.updateBase = DateLanguageUtil.convertDateTo8601(date);
    }

    public void setUpdatePeriod(String s) {
        if (!(HOURLY.equals(s) || DAILY.equals(s) || WEEKLY.equals(s) || MONTHLY.equals(s) || YEARLY.equals(s))) {
            throw new IllegalArgumentException("Invalid update period: '" + s + "' - must be one of {'" + HOURLY + "', '" + DAILY + "', '" + WEEKLY + "', '" + MONTHLY + "', '" + YEARLY + "'}");
        }
        this.updatePeriod = s;
    }

    public void setUpdateFrequency(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("Update frequency must be positive integer: " + i);
        }
        this.updateFrequency = i;
    }

    public String getUpdatePeriod() {
        return this.updatePeriod;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public String getUpdateBase() {
        return this.updateBase;
    }

    public Date getUpdateBaseAsDate() {
        return this.updateBaseDate;
    }

    public String toString() {
        return "[updatePeriod='" + this.updatePeriod + "', updateFrequency='" + this.updateFrequency + "', updateBase='" + this.updateBase + "']";
    }

    public int hashCode() {
        int hc = this.updatePeriod == null ? 0 : this.updatePeriod.hashCode();
        hc = 31 * hc + this.updateFrequency;
        hc = 31 * hc + (this.updateBase == null ? 0 : this.updateBase.hashCode());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RssSyndication)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.hashCode() == obj.hashCode();
    }

    public Object clone() {
        return this.clone();
    }
}

