/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisElementDataReader;
import org.apache.cxf.aegis.AegisElementDataWriter;
import org.apache.cxf.aegis.AegisReader;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.AegisXMLStreamDataReader;
import org.apache.cxf.aegis.AegisXMLStreamDataWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.DefaultTypeCreator;
import org.apache.cxf.aegis.type.DefaultTypeMapping;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.XMLTypeCreator;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.java5.Java5TypeCreator;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisContext {
    public static final String UTILITY_TYPES_SCHEMA_NS = "http://cxf.apache.org/aegisTypes";
    private Document aegisTypesSchemaDocument;
    private Document xmimeSchemaDocument;
    private boolean writeXsiTypes;
    private boolean readXsiTypes = true;
    private Set<String> rootClassNames;
    private Set<Type> rootClasses;
    private Set<QName> rootTypeQNames;
    private TypeMapping typeMapping;
    private Set<AegisType> rootTypes;
    private Map<Class<?>, String> beanImplementationMap = new HashMap();
    private TypeCreationOptions configuration;
    private boolean mtomEnabled;
    private boolean mtomUseXmime;
    private boolean enableJDOMMappings;
    private String mappingNamespaceURI;

    public AegisContext() {
        this.rootClasses = new HashSet<Type>();
        this.rootTypeQNames = new HashSet<QName>();
    }

    public TypeCreator createTypeCreator() {
        AbstractTypeCreator xmlCreator = this.createRootTypeCreator();
        Java5TypeCreator j5Creator = new Java5TypeCreator();
        j5Creator.setNextCreator(this.createDefaultTypeCreator());
        j5Creator.setConfiguration(this.getTypeCreationOptions());
        xmlCreator.setNextCreator(j5Creator);
        return xmlCreator;
    }

    protected AbstractTypeCreator createRootTypeCreator() {
        XMLTypeCreator creator = new XMLTypeCreator();
        creator.setConfiguration(this.getTypeCreationOptions());
        return creator;
    }

    protected AbstractTypeCreator createDefaultTypeCreator() {
        DefaultTypeCreator creator = new DefaultTypeCreator();
        creator.setConfiguration(this.getTypeCreationOptions());
        return creator;
    }

    public void initialize() {
        if (this.configuration == null) {
            this.configuration = new TypeCreationOptions();
        }
        if (this.typeMapping == null) {
            boolean defaultNillable = this.configuration.isDefaultNillable();
            DefaultTypeMapping baseTM = DefaultTypeMapping.createDefaultTypeMapping(defaultNillable, this.mtomUseXmime, this.enableJDOMMappings);
            if (this.mappingNamespaceURI == null) {
                this.mappingNamespaceURI = "urn:org.apache.cxf.aegis.types";
            }
            DefaultTypeMapping defaultTypeMapping = new DefaultTypeMapping(this.mappingNamespaceURI, baseTM);
            defaultTypeMapping.setTypeCreator(this.createTypeCreator());
            this.typeMapping = defaultTypeMapping;
        }
        this.processRootTypes();
    }

    public AegisReader<Element> createDomElementReader() {
        return new AegisElementDataReader(this);
    }

    public AegisReader<XMLStreamReader> createXMLStreamReader() {
        return new AegisXMLStreamDataReader(this);
    }

    public AegisWriter<Element> createDomElementWriter() {
        return new AegisElementDataWriter(this);
    }

    public AegisWriter<XMLStreamWriter> createXMLStreamWriter() {
        return new AegisXMLStreamDataWriter(this);
    }

    public AegisType getRootType(Class<?> clazz) {
        if (this.rootClasses.contains(clazz)) {
            return this.typeMapping.getType(clazz);
        }
        return null;
    }

    public AegisType getRootType(QName schemaTypeName) {
        if (this.rootTypeQNames.contains(schemaTypeName)) {
            return this.typeMapping.getType(schemaTypeName);
        }
        return null;
    }

    private Set<Class<?>> rootMappableClasses() {
        HashSet mappableClasses = new HashSet();
        for (Type jtype : this.rootClasses) {
            this.addTypeToMappableClasses(mappableClasses, jtype);
        }
        return mappableClasses;
    }

    private void addTypeToMappableClasses(Set<Class<?>> mappableClasses, Type jtype) {
        if (jtype instanceof Class) {
            Class jclass = (Class)jtype;
            if (jclass.isArray()) {
                mappableClasses.add(jclass.getComponentType());
            }
            mappableClasses.add(jclass);
        } else if (jtype instanceof ParameterizedType) {
            for (Type t2 : ((ParameterizedType)jtype).getActualTypeArguments()) {
                this.addTypeToMappableClasses(mappableClasses, t2);
            }
        } else if (jtype instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)jtype;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            this.rootClasses.add(ct);
        }
    }

    private void processRootTypes() {
        this.rootTypes = new HashSet<AegisType>();
        if (this.rootClasses == null) {
            this.rootClasses = new HashSet<Type>();
        }
        this.rootTypeQNames = new HashSet<QName>();
        if (this.rootClassNames != null) {
            for (String typeName : this.rootClassNames) {
                Class clazz;
                Object var3_4 = null;
                try {
                    clazz = ClassLoaderUtils.loadClass((String)typeName, TypeUtil.class);
                }
                catch (ClassNotFoundException e) {
                    throw new DatabindingException("Could not find override type class: " + typeName, (Throwable)e);
                }
                this.rootClasses.add(clazz);
            }
        }
        Set<Class<?>> rootMappableClassSet = this.rootMappableClasses();
        for (Type type : this.rootClasses) {
            if (type instanceof Class) continue;
            AegisType aegisType = this.typeMapping.getTypeCreator().createType(type);
            this.typeMapping.register(aegisType);
            this.rootTypeQNames.add(aegisType.getSchemaType());
        }
        for (Class clazz : rootMappableClassSet) {
            AegisType t = this.typeMapping.getType(clazz);
            if (t == null) {
                t = this.typeMapping.getTypeCreator().createType(clazz);
                this.typeMapping.register(t);
            }
            this.rootTypeQNames.add(t.getSchemaType());
            if (!(t instanceof BeanType)) continue;
            BeanType bt = (BeanType)t;
            bt.getTypeInfo().setExtension(true);
            this.rootTypes.add(bt);
        }
    }

    public static boolean schemaImportsUtilityTypes(XmlSchema schema) {
        return XmlSchemaUtils.schemaImportsNamespace((XmlSchema)schema, (String)UTILITY_TYPES_SCHEMA_NS);
    }

    private Document getSchemaDocument(String resourcePath) {
        try {
            return XMLUtils.parse((InputStream)this.getClass().getResourceAsStream(resourcePath));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document getAegisTypesSchemaDocument() {
        if (this.aegisTypesSchemaDocument == null) {
            this.aegisTypesSchemaDocument = this.getSchemaDocument("/META-INF/cxf/aegisTypes.xsd");
        }
        return this.aegisTypesSchemaDocument;
    }

    private Document getXmimeSchemaDocument() {
        if (this.xmimeSchemaDocument == null) {
            this.xmimeSchemaDocument = this.getSchemaDocument("/schemas/wsdl/xmime.xsd");
        }
        return this.xmimeSchemaDocument;
    }

    public XmlSchema addTypesSchemaDocument(XmlSchemaCollection collection) {
        return collection.read(this.getAegisTypesSchemaDocument(), null);
    }

    public XmlSchema addXmimeSchemaDocument(XmlSchemaCollection collection) {
        return collection.read(this.getXmimeSchemaDocument(), null);
    }

    public static void addUtilityTypesToSchema(XmlSchema root) {
        XmlSchemaUtils.addImportIfNeeded((XmlSchema)root, (String)UTILITY_TYPES_SCHEMA_NS);
    }

    public Set<String> getRootClassNames() {
        return this.rootClassNames;
    }

    public void setRootClassNames(Set<String> classNames) {
        this.rootClassNames = classNames;
    }

    public TypeCreationOptions getConfiguration() {
        return this.configuration;
    }

    public TypeCreationOptions getTypeCreationOptions() {
        return this.configuration;
    }

    public void setConfiguration(TypeCreationOptions newConfiguration) {
        this.configuration = newConfiguration;
    }

    public void setTypeCreationOptions(TypeCreationOptions newConfiguration) {
        this.configuration = newConfiguration;
    }

    public boolean isWriteXsiTypes() {
        return this.writeXsiTypes;
    }

    public boolean isReadXsiTypes() {
        return this.readXsiTypes;
    }

    public void setWriteXsiTypes(boolean flag) {
        this.writeXsiTypes = flag;
    }

    public void setReadXsiTypes(boolean flag) {
        this.readXsiTypes = flag;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Set<AegisType> getRootTypes() {
        return this.rootTypes;
    }

    public Map<Class<?>, String> getBeanImplementationMap() {
        return this.beanImplementationMap;
    }

    public void setBeanImplementationMap(Map<Class<?>, String> beanImplementationMap) {
        this.beanImplementationMap = beanImplementationMap;
    }

    public Set<Type> getRootClasses() {
        return this.rootClasses;
    }

    public void setRootClasses(Set<Type> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomUseXmime() {
        return this.mtomUseXmime;
    }

    public void setMtomUseXmime(boolean mtomUseXmime) {
        this.mtomUseXmime = mtomUseXmime;
    }

    public String getMappingNamespaceURI() {
        return this.mappingNamespaceURI;
    }

    public void setMappingNamespaceURI(String mappingNamespaceURI) {
        this.mappingNamespaceURI = mappingNamespaceURI;
        if (this.typeMapping != null) {
            this.typeMapping.setMappingIdentifierURI(mappingNamespaceURI);
        }
    }

    public boolean isEnableJDOMMappings() {
        return this.enableJDOMMappings;
    }

    public void setEnableJDOMMappings(boolean enableJDOMMappings) {
        this.enableJDOMMappings = enableJDOMMappings;
    }
}

