/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.interceptors;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class PojoEvictionInterceptor
extends EvictionInterceptor {
    private static final Log log_ = LogFactory.getLog((Class)PojoEvictionInterceptor.class);
    private TreeCache cache = null;

    public PojoEvictionInterceptor() {
        EvictionInterceptor.EvictionMethodHandler handler = new PojoGetNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.getNodeMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.getDataMapMethodLocal, handler);
        handler = new PojoGetKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.getKeyValueMethodLocal, handler);
        handler = new PojoRemoveNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.removeNodeMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.removeDataMethodLocal, handler);
        handler = new PojoRemoveKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.removeKeyMethodLocal, handler);
        handler = new PojoPutDataEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putDataMethodLocal, handler);
        handler = new PojoPutDataEraseEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putDataEraseMethodLocal, handler);
        handler = new PojoPutKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putKeyValMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.putFailFastKeyValueMethodLocal, handler);
    }

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.cache = cache;
    }

    boolean isAopNode(Fqn fqn) {
        DataNode node = null;
        node = this.cache.peek(fqn);
        return node.get(AOPInstance.KEY) != null;
    }

    private void visitChildrenRecursively(Region region, Fqn fqn) {
        int size;
        Set set = null;
        try {
            set = this.cache.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        int n = size = set == null ? 0 : set.size();
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("nodeVisited(): is an aop node. fqn- " + fqn + " size of children is " + size));
        }
        if (set == null) {
            return;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object childName = it.next();
            Fqn fqnKid = new Fqn(fqn, childName);
            this.visitChildrenRecursively(region, fqnKid);
            region.setVisitedNode(fqnKid);
        }
    }

    private boolean isInternalNode(Fqn fqn) {
        return InternalDelegate.isInternalNode(fqn);
    }

    protected class PojoPutKeyEvictionMethodHandler
    extends EvictionInterceptor.PutKeyEvictionMethodHandler {
        protected PojoPutKeyEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                return null;
            }
            return super.extractEvictedEventNode(mc, retVal);
        }
    }

    protected class PojoPutDataEraseEvictionMethodHandler
    extends EvictionInterceptor.PutDataEraseEvictionMethodHandler {
        protected PojoPutDataEraseEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                return null;
            }
            return super.extractEvictedEventNode(mc, retVal);
        }
    }

    protected class PojoPutDataEvictionMethodHandler
    extends EvictionInterceptor.PutDataEvictionMethodHandler {
        protected PojoPutDataEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                return null;
            }
            return super.extractEvictedEventNode(mc, retVal);
        }
    }

    protected class PojoRemoveKeyEvictionMethodHandler
    extends EvictionInterceptor.RemoveKeyEvictionMethodHandler {
        protected PojoRemoveKeyEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                return null;
            }
            return super.extractEvictedEventNode(mc, retVal);
        }
    }

    protected class PojoRemoveNodeEvictionMethodHandler
    extends EvictionInterceptor.RemoveNodeEvictionMethodHandler {
        protected PojoRemoveNodeEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                return null;
            }
            return super.extractEvictedEventNode(mc, retVal);
        }
    }

    protected class PojoGetKeyEvictionMethodHandler
    extends EvictionInterceptor.GetKeyEvictionMethodHandler {
        protected PojoGetKeyEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            EvictedEventNode event = super.extractEvictedEventNode(mc, retVal);
            if (event != null) {
                Object[] args = mc.getArgs();
                Fqn fqn = (Fqn)args[0];
                Region region = PojoEvictionInterceptor.this.regionManager.getRegion(fqn);
                if (PojoEvictionInterceptor.this.isAopNode(fqn)) {
                    PojoEvictionInterceptor.this.visitChildrenRecursively(region, fqn);
                }
                if (fqn != null && !PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                    return new EvictedEventNode(fqn, 2);
                }
            }
            return null;
        }
    }

    protected class PojoGetNodeEvictionMethodHandler
    extends EvictionInterceptor.GetNodeEvictionMethodHandler {
        protected PojoGetNodeEvictionMethodHandler() {
            super(PojoEvictionInterceptor.this);
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            EvictedEventNode event = super.extractEvictedEventNode(mc, retVal);
            if (event != null) {
                Object[] args = mc.getArgs();
                Fqn fqn = (Fqn)args[0];
                Region region = PojoEvictionInterceptor.this.regionManager.getRegion(fqn);
                if (PojoEvictionInterceptor.this.isAopNode(fqn)) {
                    PojoEvictionInterceptor.this.visitChildrenRecursively(region, fqn);
                }
                if (fqn != null && !PojoEvictionInterceptor.this.isInternalNode(fqn)) {
                    return new EvictedEventNode(fqn, 2);
                }
            }
            return null;
        }
    }
}

