/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.utils.Base64;

public class ExportJournal {
    public static void main(String[] arg) {
        if (arg.length != 5) {
            System.err.println("Use: java -cp hornetq-core.jar org.hornetq.core.journal.impl.ExportJournal <JournalDirectory> <JournalPrefix> <FileExtension> <FileSize> <FileOutput>");
            return;
        }
        try {
            ExportJournal.exportJournal(arg[0], arg[1], arg[2], 2, Integer.parseInt(arg[3]), arg[4]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exportJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, String fileOutput) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(new File(fileOutput));
        BufferedOutputStream buffOut = new BufferedOutputStream(fileOut);
        PrintStream out = new PrintStream(buffOut);
        ExportJournal.exportJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, out);
        out.close();
    }

    public static void exportJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, PrintStream out) throws Exception {
        NIOSequentialFileFactory nio = new NIOSequentialFileFactory(directory, null);
        JournalImpl journal = new JournalImpl(fileSize, minFiles, 0, 0, nio, journalPrefix, journalSuffix, 1);
        List<JournalFile> files = journal.orderFiles();
        for (JournalFile file : files) {
            out.println("#File," + file);
            ExportJournal.exportJournalFile(out, nio, file);
        }
    }

    public static void exportJournalFile(final PrintStream out, SequentialFileFactory fileFactory, JournalFile file) throws Exception {
        JournalImpl.readJournalFile(fileFactory, file, new JournalReaderCallback(){

            @Override
            public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@UpdateTX,txID@" + transactionID + "," + ExportJournal.describeRecord(recordInfo));
            }

            @Override
            public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                out.println("operation@Update," + ExportJournal.describeRecord(recordInfo));
            }

            @Override
            public void onReadRollbackRecord(long transactionID) throws Exception {
                out.println("operation@Rollback,txID@" + transactionID);
            }

            @Override
            public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                out.println("operation@Prepare,txID@" + transactionID + ",numberOfRecords@" + numberOfRecords + ",extraData@" + ExportJournal.encode(extraData));
            }

            @Override
            public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@DeleteRecordTX,txID@" + transactionID + "," + ExportJournal.describeRecord(recordInfo));
            }

            @Override
            public void onReadDeleteRecord(long recordID) throws Exception {
                out.println("operation@DeleteRecord,id@" + recordID);
            }

            @Override
            public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                out.println("operation@Commit,txID@" + transactionID + ",numberOfRecords@" + numberOfRecords);
            }

            @Override
            public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@AddRecordTX,txID@" + transactionID + "," + ExportJournal.describeRecord(recordInfo));
            }

            @Override
            public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                out.println("operation@AddRecord," + ExportJournal.describeRecord(recordInfo));
            }

            @Override
            public void markAsDataFile(JournalFile file) {
            }
        });
    }

    private static String describeRecord(RecordInfo recordInfo) {
        return "id@" + recordInfo.id + ",userRecordType@" + recordInfo.userRecordType + ",length@" + recordInfo.data.length + ",isUpdate@" + recordInfo.isUpdate + ",compactCount@" + recordInfo.compactCount + ",data@" + ExportJournal.encode(recordInfo.data);
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }
}

