/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptor;
import org.omg.CORBA.Any;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class BiDirConnectionClientInterceptor
extends DefaultClientInterceptor {
    private static final String name = "BiDirConnectionClientInterceptor";
    private final ORB orb;
    private ServiceContext bidir_ctx = null;

    public BiDirConnectionClientInterceptor(ORB orb) {
        this.orb = orb;
    }

    public String name() {
        return name;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (this.orb.useBiDirGIOP() && ((ClientRequestInfoImpl)ri).connection.isClientInitiated()) {
            if (this.bidir_ctx == null) {
                BasicAdapter ba = this.orb.getBasicAdapter();
                ListenPoint lp = new ListenPoint(ba.getAddress(), (short)ba.getPort());
                ListenPoint[] points = null;
                if (ba.hasSSLListener()) {
                    ListenPoint ssl_lp = new ListenPoint(ba.getAddress(), (short)ba.getSSLPort());
                    points = new ListenPoint[]{lp, ssl_lp};
                } else {
                    points = new ListenPoint[]{lp};
                }
                BiDirIIOPServiceContext b = new BiDirIIOPServiceContext(points);
                Any any = this.orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, b);
                CDROutputStream cdr_out = new CDROutputStream(this.orb);
                try {
                    cdr_out.beginEncapsulatedArray();
                    BiDirIIOPServiceContextHelper.write(cdr_out, b);
                    this.bidir_ctx = new ServiceContext(5, cdr_out.getBufferCopy());
                }
                finally {
                    cdr_out.close();
                }
            }
            ri.add_request_service_context(this.bidir_ctx, true);
            GIOPConnection conn = ((ClientRequestInfoImpl)ri).connection.getGIOPConnection();
            if (conn.getRequestListener() instanceof NoBiDirClientRequestListener) {
                conn.setRequestListener(this.orb.getBasicAdapter().getRequestListener());
            }
        }
    }
}

