/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.server;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JSR160ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXComponent;

public class JBossAS7JMXComponent<T extends ResourceComponent<?>>
implements ResourceComponent<T>,
JMXComponent<T> {
    public static final String PLUGIN_CONFIG_CLIENT_JAR_LOCATION = "clientJarLocation";
    public static final String PLUGIN_CONFIG_PORT = "port";
    public static final String PLUGIN_CONFIG_HOSTNAME = "hostname";
    public static final String PLUGIN_CONFIG_USERNAME = "username";
    public static final String PLUGIN_CONFIG_PASSWORD = "password";
    public static final String DEFAULT_PLUGIN_CONFIG_PORT = "9999";
    private Log log = LogFactory.getLog(JBossAS7JMXComponent.class);
    private ResourceContext<T> resourceContext;
    private EmsConnection connection;
    private int consecutiveConnectionErrors;

    public AvailabilityType getAvailability() {
        try {
            EmsConnection conn = this.getEmsConnection();
            if (conn == null) {
                return AvailabilityType.DOWN;
            }
            conn.queryBeans("java.lang:*");
            return AvailabilityType.UP;
        }
        catch (Throwable t) {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<T> context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        this.loadConnection();
    }

    public void stop() {
    }

    public EmsConnection getEmsConnection() {
        EmsConnection emsConnection = null;
        try {
            emsConnection = this.loadConnection();
        }
        catch (Exception e) {
            this.log.error((Object)("Component attempting to access a connection that could not be loaded: " + e.getCause()));
        }
        return emsConnection;
    }

    private EmsConnection loadConnection() throws Exception {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String hostname = pluginConfig.getSimpleValue(PLUGIN_CONFIG_HOSTNAME, "127.0.0.1");
            String port = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PORT, DEFAULT_PLUGIN_CONFIG_PORT);
            String username = pluginConfig.getSimpleValue(PLUGIN_CONFIG_USERNAME, "rhqadmin");
            String password = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PASSWORD, "rhqadmin");
            ConnectionSettings connectionSettings = new ConnectionSettings();
            connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)new JSR160ConnectionTypeDescriptor());
            connectionSettings.setServerUrl("service:jmx:remoting-jmx://" + hostname + ":" + port);
            connectionSettings.setPrincipal(username);
            connectionSettings.setCredentials(password);
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.discoverServerClasses(connectionSettings);
            if (connectionSettings.getAdvancedProperties() == null) {
                connectionSettings.setAdvancedProperties(new Properties());
            }
            this.log.info((Object)("Loading AS7 connection [" + connectionSettings.getServerUrl() + "] with install path [" + connectionSettings.getLibraryURI() + "]..."));
            ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
            this.connection = connectionProvider.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Successfully made connection to the AS7 instance for resource [" + this.resourceContext.getResourceKey() + "]"));
            }
            return this.connection;
        }
        catch (Exception e) {
            if (this.connection != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Connection created but an exception was thrown. Closing the connection.", (Throwable)e);
                }
                this.connection.close();
                this.connection = null;
            }
            if (this.consecutiveConnectionErrors % 10 == 0) {
                this.log.warn((Object)("Could not establish connection to the JBoss AS instance [" + (this.consecutiveConnectionErrors + 1) + "] times for resource [" + this.resourceContext.getResourceKey() + "]"), (Throwable)e);
            }
            ++this.consecutiveConnectionErrors;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Can't connect to JBoss AS resource  [" + this.resourceContext.getResourceKey() + "]"), (Throwable)e);
            }
            throw e;
        }
    }
}

