/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.ObjectSizeEstimator;

public class RequestThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    private static final int CORE_THREAD_TIMEOUT_SEC = 30;
    private static final int MAX_QUEUED_REQUESTS = 128;

    public RequestThreadPoolExecutor() {
        super(DatabaseDescriptor.getNativeTransportMaxThreads().intValue(), 0L, 128L, 30L, TimeUnit.SECONDS, RequestThreadPoolExecutor.sizeEstimator(), (ThreadFactory)new NamedThreadFactory("Native-Transport-Requests"));
    }

    private static ObjectSizeEstimator sizeEstimator() {
        return new ObjectSizeEstimator(){

            public int estimateSize(Object o) {
                return 1;
            }
        };
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
    }
}

