/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.impl.EntitiesAtRevisionQuery;
import org.hibernate.envers.query.impl.EntitiesModifiedAtRevisionQuery;
import org.hibernate.envers.query.impl.RevisionsOfEntityQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.ArgumentsTools;
import org.hibernate.envers.tools.Tools;

public class AuditQueryCreator {
    private final AuditConfiguration auditCfg;
    private final AuditReaderImplementor auditReaderImplementor;

    public AuditQueryCreator(AuditConfiguration auditCfg, AuditReaderImplementor auditReaderImplementor) {
        this.auditCfg = auditCfg;
        this.auditReaderImplementor = auditReaderImplementor;
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = Tools.getTargetClassIfProxied(c);
        return new EntitiesAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, revision);
    }

    public AuditQuery forEntitiesAtRevision(Class<?> c, String entityName, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = Tools.getTargetClassIfProxied(c);
        return new EntitiesAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, entityName, revision);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, String entityName, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = Tools.getTargetClassIfProxied(c);
        return new EntitiesModifiedAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, entityName, revision);
    }

    public AuditQuery forEntitiesModifiedAtRevision(Class<?> c, Number revision) {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        c = Tools.getTargetClassIfProxied(c);
        return new EntitiesModifiedAtRevisionQuery(this.auditCfg, this.auditReaderImplementor, c, revision);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = Tools.getTargetClassIfProxied(c);
        return new RevisionsOfEntityQuery(this.auditCfg, this.auditReaderImplementor, c, selectEntitiesOnly, selectDeletedEntities);
    }

    public AuditQuery forRevisionsOfEntity(Class<?> c, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        c = Tools.getTargetClassIfProxied(c);
        return new RevisionsOfEntityQuery(this.auditCfg, this.auditReaderImplementor, c, entityName, selectEntitiesOnly, selectDeletedEntities);
    }
}

