/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleValidatorR3;
import org.jboss.osgi.framework.internal.BundleValidatorR4;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

abstract class UserBundleInstalledService<B extends UserBundleState, R extends UserBundleRevision>
extends AbstractBundleService<B> {
    private final Deployment initialDeployment;
    private B bundleState;

    UserBundleInstalledService(FrameworkState frameworkState, Deployment deployment) {
        super(frameworkState);
        this.initialDeployment = deployment;
    }

    ServiceName install(ServiceTarget serviceTarget, ServiceListener<XBundle> listener) {
        ServiceName serviceName = this.getBundleManager().getServiceName(this.initialDeployment, 2);
        FrameworkLogger.LOGGER.tracef("Installing %s %s", this.getClass().getSimpleName(), serviceName);
        ServiceBuilder builder = serviceTarget.addService(serviceName, new ServiceTracker.SynchronousListenerServiceWrapper(this));
        this.addServiceDependencies(builder);
        if (listener != null) {
            builder.addListener(listener);
        }
        return builder.install().getName();
    }

    protected void addServiceDependencies(ServiceBuilder<B> builder) {
        builder.addDependency(IntegrationServices.FRAMEWORK_CORE_SERVICES);
    }

    @Override
    public void start(StartContext context) throws StartException {
        StorageState storageState = null;
        try {
            Deployment dep = this.initialDeployment;
            Long bundleId = (Long)dep.getAttachment(Long.class);
            storageState = this.createStorageState(dep, bundleId);
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
            R brev = this.createBundleRevision(dep, metadata, storageState);
            brev.addAttachment(Long.class, (Object)bundleId);
            ServiceName serviceName = context.getController().getName().getParent();
            this.bundleState = this.createBundleState(brev, serviceName, context.getChildTarget());
            dep.addAttachment(Bundle.class, this.bundleState);
            ((UserBundleState)this.bundleState).initLazyActivation();
            this.validateBundle((UserBundleState)this.bundleState, metadata);
            this.processNativeCode((UserBundleState)this.bundleState, dep);
            this.installBundle((UserBundleState)this.bundleState);
            ((AbstractBundleState)this.bundleState).fireBundleEvent(1);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                BundleStorage storagePlugin = this.getFrameworkState().getBundleStorage();
                storagePlugin.deleteStorageState(storageState);
            }
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        if (this.getBundleState().getState() != 1) {
            try {
                this.getBundleManager().uninstallBundle(this.getBundleState(), 1);
            }
            catch (BundleException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    abstract R createBundleRevision(Deployment var1, OSGiMetaData var2, StorageState var3) throws BundleException;

    abstract B createBundleState(R var1, ServiceName var2, ServiceTarget var3) throws BundleException;

    StorageState createStorageState(Deployment dep, Long bundleId) throws BundleException {
        StorageState storageState = (StorageState)dep.getAttachment(StorageState.class);
        if (storageState == null) {
            String location = dep.getLocation();
            VirtualFile rootFile = dep.getRoot();
            try {
                BundleStorage storagePlugin = this.getFrameworkState().getBundleStorage();
                Integer startlevel = dep.getStartLevel();
                if (startlevel == null) {
                    CoreServices coreServices = this.getFrameworkState().getCoreServices();
                    startlevel = coreServices.getStartLevelSupport().getInitialBundleStartLevel();
                }
                storageState = storagePlugin.createStorageState(bundleId, location, startlevel, rootFile);
                dep.addAttachment(StorageState.class, (Object)storageState);
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
            }
        }
        return storageState;
    }

    @Override
    B getBundleState() {
        return this.bundleState;
    }

    private void installBundle(UserBundleState userBundle) throws BundleException {
        boolean addToEnvironment = true;
        if (userBundle.isSingleton()) {
            String symbolicName = userBundle.getSymbolicName();
            for (XBundle aux : this.getBundleManager().getBundles(symbolicName, null)) {
                if (aux == userBundle || !this.isSingleton(aux)) continue;
                FrameworkLogger.LOGGER.infoNoResolvableSingleton((Bundle)userBundle);
                addToEnvironment = false;
                break;
            }
        }
        if (addToEnvironment) {
            XEnvironment env = this.getFrameworkState().getEnvironment();
            env.installResources(new XResource[]{userBundle.getBundleRevision()});
        }
        userBundle.changeState(2, 0);
        FrameworkLogger.LOGGER.infoBundleInstalled((Bundle)userBundle);
    }

    private boolean isSingleton(XBundle userBundle) {
        if (userBundle instanceof UserBundleState) {
            UserBundleState bundleState = (UserBundleState)userBundle;
            return bundleState.isSingleton();
        }
        return false;
    }

    private void validateBundle(UserBundleState userBundle, OSGiMetaData metadata) throws BundleException {
        if (metadata.getBundleManifestVersion() > 1) {
            new BundleValidatorR4().validateBundle(userBundle, metadata);
        } else {
            new BundleValidatorR3().validateBundle(userBundle, metadata);
        }
    }

    private void processNativeCode(UserBundleState userBundle, Deployment dep) {
        OSGiMetaData metadata = userBundle.getOSGiMetaData();
        if (metadata.getBundleNativeCode() != null) {
            FrameworkState frameworkState = userBundle.getFrameworkState();
            NativeCode nativeCodePlugin = frameworkState.getNativeCode();
            nativeCodePlugin.deployNativeCode(dep);
        }
    }
}

