/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.NoFilter;
import org.jboss.osgi.framework.internal.RemoveOnlyCollection;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceStateImpl;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.ServiceManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public final class ServiceManagerImpl
implements ServiceManager {
    private final FrameworkEvents frameworkEvents;
    private final Map<String, List<ServiceState>> serviceContainer = new HashMap<String, List<ServiceState>>();
    private final AtomicLong identityGenerator = new AtomicLong();

    public ServiceManagerImpl(FrameworkEvents frameworkEvents) {
        this.frameworkEvents = frameworkEvents;
    }

    @Override
    public void fireFrameworkEvent(XBundle bundle2, int type, ServiceException ex) {
        this.frameworkEvents.fireFrameworkEvent((Bundle)bundle2, type, (Throwable)ex);
    }

    @Override
    public void fireServiceEvent(XBundle bundle2, int type, ServiceState serviceState) {
        this.frameworkEvents.fireServiceEvent(bundle2, type, serviceState);
    }

    private long getNextServiceId() {
        return this.identityGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceState registerService(XBundle bundle2, String[] classNames, final Object serviceValue, Dictionary properties) {
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        Collection<ListenerHook.ListenerInfo> listenerInfos = null;
        if (serviceValue instanceof ListenerHook) {
            listenerInfos = this.frameworkEvents.getServiceListenerInfos(null);
        }
        ServiceState.ValueProvider valueProvider = new ServiceState.ValueProvider(){

            @Override
            public boolean isFactoryValue() {
                return serviceValue instanceof ServiceFactory;
            }

            @Override
            public Object getValue() {
                return serviceValue;
            }
        };
        long serviceId = this.getNextServiceId();
        AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
        ServiceStateImpl serviceState = new ServiceStateImpl(this, bundleState, serviceId, classNames, valueProvider, properties);
        FrameworkLogger.LOGGER.debugf("Register service: %s", serviceState);
        Map<String, List<ServiceState>> map = this.serviceContainer;
        synchronized (map) {
            for (String className : classNames) {
                List<ServiceState> serviceStates = this.serviceContainer.get(className);
                if (serviceStates != null) {
                    serviceStates.add(serviceState);
                    continue;
                }
                serviceStates = new CopyOnWriteArrayList<ServiceState>();
                serviceStates.add(serviceState);
                this.serviceContainer.put(className, serviceStates);
            }
        }
        bundleState.addRegisteredService(serviceState);
        if (serviceValue instanceof ListenerHook) {
            ListenerHook listenerHook = (ListenerHook)serviceValue;
            listenerHook.added(listenerInfos);
        }
        this.frameworkEvents.fireServiceEvent(bundleState, 1, serviceState);
        return serviceState;
    }

    @Override
    public ServiceState getServiceReference(XBundle bundle2, String clazz) {
        assert (clazz != null) : "Null clazz";
        boolean checkAssignable = bundle2.getBundleId() != 0L;
        List<ServiceState> result = this.getServiceReferencesInternal(bundle2, clazz, NoFilter.INSTANCE, checkAssignable);
        if ((result = this.processFindHooks(bundle2, clazz, null, true, result)).isEmpty()) {
            return null;
        }
        int lastIndex = result.size() - 1;
        return result.get(lastIndex);
    }

    @Override
    public List<ServiceState> getServiceReferences(XBundle bundle2, String clazz, String filterStr, boolean checkAssignable) throws InvalidSyntaxException {
        Filter filter = NoFilter.INSTANCE;
        if (filterStr != null) {
            filter = FrameworkUtil.createFilter((String)filterStr);
        }
        List<ServiceState> result = this.getServiceReferencesInternal(bundle2, clazz, filter, checkAssignable);
        result = this.processFindHooks(bundle2, clazz, filterStr, checkAssignable, result);
        return result;
    }

    private List<ServiceState> getServiceReferencesInternal(XBundle bundle2, String className, Filter filter, boolean checkAssignable) {
        assert (bundle2 != null) : "Null bundleState";
        assert (filter != null) : "Null filter";
        HashSet<ServiceState> initialSet = new HashSet<ServiceState>();
        if (className != null) {
            List<ServiceState> list = this.serviceContainer.get(className);
            if (list != null) {
                initialSet.addAll(list);
            }
        } else {
            for (List<ServiceState> list : this.serviceContainer.values()) {
                initialSet.addAll(list);
            }
        }
        if (initialSet.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceState> resultset = new HashSet<ServiceState>();
        for (ServiceState serviceState : initialSet) {
            if (!this.isMatchingService(bundle2, serviceState, className, filter, checkAssignable)) continue;
            resultset.add(serviceState);
        }
        ArrayList resultList = new ArrayList(resultset);
        if (resultList.size() > 1) {
            Collections.sort(resultList, ServiceReferenceComparator.getInstance());
        }
        return Collections.unmodifiableList(resultList);
    }

    private boolean isMatchingService(XBundle bundle2, ServiceState serviceState, String clazzName, Filter filter, boolean checkAssignable) {
        if (serviceState.isUnregistered() || !filter.match((ServiceReference)serviceState)) {
            return false;
        }
        if (!checkAssignable || clazzName == null) {
            return true;
        }
        return serviceState.isAssignableTo((Bundle)bundle2, clazzName);
    }

    @Override
    public Object getService(XBundle bundle2, ServiceState serviceState) {
        if (serviceState.isUnregistered()) {
            return null;
        }
        AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
        bundleState.addServiceInUse(serviceState);
        serviceState.addUsingBundle(bundleState);
        Object value = serviceState.getScopedValue(bundleState);
        if (value == null) {
            bundleState.removeServiceInUse(serviceState);
            serviceState.removeUsingBundle(bundleState);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(ServiceState serviceState) {
        ServiceState serviceState2 = serviceState;
        synchronized (serviceState2) {
            if (serviceState.isUnregistered()) {
                return;
            }
            Map<String, List<ServiceState>> map = this.serviceContainer;
            synchronized (map) {
                for (String className : serviceState.getClassNames()) {
                    FrameworkLogger.LOGGER.debugf("Unregister service: %s", className);
                    try {
                        List<ServiceState> serviceStates = this.serviceContainer.get(className);
                        if (serviceStates == null) continue;
                        serviceStates.remove(serviceState);
                    }
                    catch (RuntimeException ex) {
                        FrameworkLogger.LOGGER.errorCannotRemoveService(ex, className);
                    }
                }
            }
            XBundle serviceOwner = serviceState.getServiceOwner();
            this.frameworkEvents.fireServiceEvent(serviceOwner, 4, serviceState);
            for (XBundle bundle2 : serviceState.getUsingBundlesInternal()) {
                while (this.ungetService(bundle2, serviceState)) {
                }
            }
            if (serviceOwner instanceof AbstractBundleState) {
                AbstractBundleState<?> ownerState = AbstractBundleState.assertBundleState((Bundle)serviceOwner);
                ownerState.removeRegisteredService(serviceState);
            }
        }
    }

    @Override
    public boolean ungetService(XBundle bundle2, ServiceState serviceState) {
        AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
        serviceState.ungetScopedValue(bundleState);
        int useCount = bundleState.removeServiceInUse(serviceState);
        if (useCount == 0) {
            serviceState.removeUsingBundle(bundleState);
        }
        return useCount >= 0;
    }

    private List<ServiceState> processFindHooks(XBundle bundle2, String clazz, String filterStr, boolean checkAssignable, List<ServiceState> serviceStates) {
        BundleContext context = bundle2.getBundleContext();
        List<ServiceState> hookRefs = this.getServiceReferencesInternal(bundle2, FindHook.class.getName(), NoFilter.INSTANCE, true);
        if (hookRefs.isEmpty()) {
            return serviceStates;
        }
        if (clazz != null && clazz.startsWith(FindHook.class.getPackage().getName())) {
            return serviceStates;
        }
        ArrayList<ServiceState> sortedHookRefs = new ArrayList<ServiceState>(hookRefs);
        Collections.reverse(sortedHookRefs);
        ArrayList<FindHook> hooks = new ArrayList<FindHook>();
        for (ServiceReference serviceReference : sortedHookRefs) {
            hooks.add((FindHook)context.getService(serviceReference));
        }
        Collection hookParam = new ArrayList<ServiceReference>();
        for (ServiceState aux : serviceStates) {
            hookParam.add(aux.getReference());
        }
        hookParam = new RemoveOnlyCollection(hookParam);
        for (FindHook hook : hooks) {
            try {
                hook.find(context, clazz, filterStr, !checkAssignable, hookParam);
            }
            catch (Exception ex) {
                FrameworkLogger.LOGGER.warnErrorWhileCallingFindHook(ex, hook);
            }
        }
        ArrayList<ServiceState> arrayList = new ArrayList<ServiceState>();
        for (ServiceReference aux : hookParam) {
            ServiceStateImpl serviceState = ServiceStateImpl.assertServiceState(aux);
            arrayList.add(serviceState);
        }
        return arrayList;
    }
}

