/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.osgi.framework.BundleException;

final class PersistentBundlesInstallPlugin
extends BootstrapBundlesInstall<Void> {
    private final InjectedValue<BundleStorage> injectedStoragePlugin = new InjectedValue();
    private final InjectedValue<DeploymentProvider> injectedDeploymentFactory = new InjectedValue();

    PersistentBundlesInstallPlugin() {
        super(IntegrationServices.PERSISTENT_BUNDLES);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(IntegrationServices.BUNDLE_STORAGE, BundleStorage.class, this.injectedStoragePlugin);
        builder.addDependency(IntegrationServices.DEPLOYMENT_PROVIDER_PLUGIN, DeploymentProvider.class, this.injectedDeploymentFactory);
        builder.addDependencies(new ServiceName[]{IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE});
    }

    @Override
    public void start(StartContext context) throws StartException {
        DeploymentProvider deploymentPlugin = (DeploymentProvider)this.injectedDeploymentFactory.getValue();
        ServiceTarget serviceTarget = context.getChildTarget();
        BundleStorage storageStatePlugin = (BundleStorage)this.injectedStoragePlugin.getValue();
        HashSet<StorageState> storageStates = new HashSet<StorageState>(storageStatePlugin.getStorageStates());
        Iterator iterator = storageStates.iterator();
        while (iterator.hasNext()) {
            StorageState storageState = (StorageState)iterator.next();
            if (this.getBundleManager().getBundleById(storageState.getBundleId()) == null) continue;
            iterator.remove();
        }
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (StorageState storageState : storageStates) {
            try {
                Deployment dep = deploymentPlugin.createDeployment(storageState);
                deployments.add(dep);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, storageState.getLocation());
            }
        }
        this.installBootstrapBundles(serviceTarget, deployments);
    }
}

