/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleResolvedService;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;

final class HostBundleRevision
extends UserBundleRevision {
    private Set<FragmentBundleRevision> attachedFragments;
    private FallbackLoader fallbackLoader;

    HostBundleRevision(FrameworkState frameworkState, Deployment dep, OSGiMetaData metadata, StorageState storageState) throws BundleException {
        super(frameworkState, dep, metadata, storageState);
    }

    static HostBundleRevision assertHostRevision(BundleRevision brev) {
        assert (brev instanceof HostBundleRevision) : "Not a HostRevision: " + brev;
        return (HostBundleRevision)brev;
    }

    HostBundleState getBundleState() {
        return (HostBundleState)this.getBundle();
    }

    @Override
    void refreshRevisionInternal() {
        super.refreshRevisionInternal();
        this.attachedFragments = null;
    }

    void createResolvedService(ServiceTarget serviceTarget) {
        ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
        FrameworkModuleLoader moduleLoader = this.getFrameworkState().getFrameworkModuleLoader();
        ModuleIdentifier identifier = moduleManager.getModuleIdentifier((XBundleRevision)this);
        ServiceName moduleServiceName = moduleLoader.getModuleServiceName(identifier);
        HostBundleResolvedService.addService(serviceTarget, this.getBundleState(), moduleServiceName);
    }

    void attachFragment(FragmentBundleRevision fragRev) {
        if (this.attachedFragments == null) {
            Comparator<FragmentBundleRevision> comp = new Comparator<FragmentBundleRevision>(){

                @Override
                public int compare(FragmentBundleRevision rev1, FragmentBundleRevision rev2) {
                    XBundle b1 = rev1.getBundle();
                    XBundle b2 = rev2.getBundle();
                    return (int)(b1.getBundleId() - b2.getBundleId());
                }
            };
            this.attachedFragments = new TreeSet<FragmentBundleRevision>(comp);
        }
        this.attachedFragments.add(fragRev);
    }

    Set<FragmentBundleRevision> getAttachedFragments() {
        if (this.attachedFragments == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.attachedFragments);
    }

    void setFallbackLoader(FallbackLoader fallbackLoader) {
        this.fallbackLoader = fallbackLoader;
    }

    FallbackLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.getBundleState().ensureResolved(true)) {
            throw FrameworkMessages.MESSAGES.classNotFoundInRevision(className, (BundleRevision)this);
        }
        ModuleClassLoader loader = this.getModuleClassLoader();
        return loader.loadClass(className, true);
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().ensureResolved(true);
        return this.findResolvedEntries(path, pattern, recurse);
    }

    Enumeration<URL> findResolvedEntries(String path, String pattern, boolean recurse) {
        Enumeration<URL> hostEntries = super.findEntries(path, pattern, recurse);
        Set<FragmentBundleRevision> fragments = this.getAttachedFragments();
        if (fragments.size() == 0) {
            return hostEntries;
        }
        ArrayList<URL> allEntries = hostEntries == null ? new ArrayList<URL>() : new ArrayList<URL>(Collections.list(hostEntries));
        for (FragmentBundleRevision fragmentRevision : fragments) {
            Enumeration<URL> fragEntries = fragmentRevision.findEntries(path, pattern, recurse);
            if (fragEntries == null) continue;
            allEntries.addAll(Collections.list(fragEntries));
        }
        if (allEntries.size() == 0) {
            return null;
        }
        return Collections.enumeration(allEntries);
    }

    public URL getResource(String path) {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved(false)) {
            ModuleClassLoader moduleClassLoader = this.getModuleClassLoader();
            return moduleClassLoader.getResource(path);
        }
        return this.getEntry(path);
    }

    public Enumeration<URL> getResources(String path) throws IOException {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved(true)) {
            ModuleClassLoader moduleClassLoader = this.getModuleClassLoader();
            Enumeration resources = moduleClassLoader.getResources(path);
            return resources.hasMoreElements() ? resources : null;
        }
        Vector<URL> vector = new Vector<URL>();
        for (RevisionContent revContent : this.getClassPathContent()) {
            try {
                VirtualFile child = revContent.getVirtualFile().getChild(path);
                if (child == null) continue;
                vector.add(child.toURL());
            }
            catch (IOException ex) {
                FrameworkLogger.LOGGER.errorCannotGetResources(ex, path, (BundleRevision)this);
                return null;
            }
        }
        return vector.isEmpty() ? null : vector.elements();
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL entry = this.getEntry(path);
        if (entry != null) {
            return entry;
        }
        for (FragmentBundleRevision fragrev : this.getAttachedFragments()) {
            if (fragrev.getBundleState().isUninstalled() || (entry = fragrev.getEntry(path)) == null) continue;
            return entry;
        }
        return null;
    }
}

