/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.framework.spi.ServiceManager;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.BundleContext;

public final class FrameworkCreate
extends AbstractFrameworkService {
    private final FrameworkState frameworkState;
    private final ServiceController.Mode initialMode;

    FrameworkCreate(FrameworkState frameworkState, ServiceController.Mode initialMode) {
        super(IntegrationServices.FRAMEWORK_CREATE_INTERNAL);
        this.frameworkState = frameworkState;
        this.initialMode = initialMode;
    }

    @Override
    public ServiceController<FrameworkState> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceController controller = super.install(serviceTarget, listener);
        new FrameworkCreated().install(serviceTarget, listener);
        return controller;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(IntegrationServices.DEPLOYMENT_PROVIDER_PLUGIN, DeploymentProvider.class, this.frameworkState.injectedDeploymentFactory);
        builder.addDependency(IntegrationServices.FRAMEWORK_EVENTS, FrameworkEvents.class, this.frameworkState.injectedFrameworkEvents);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_LOADER, FrameworkModuleLoader.class, this.frameworkState.injectedModuleLoader);
        builder.addDependency(IntegrationServices.NATIVE_CODE_PLUGIN, NativeCode.class, this.frameworkState.injectedNativeCode);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.frameworkState.injectedResolverPlugin);
        builder.addDependency(IntegrationServices.SERVICE_MANAGER, ServiceManager.class, this.frameworkState.injectedServiceManager);
        builder.addDependency(IntegrationServices.SYSTEM_BUNDLE_INTERNAL, SystemBundleState.class, this.frameworkState.injectedSystemBundle);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        this.getBundleManagerPlugin().injectedFramework.inject((Object)this.frameworkState);
    }

    @Override
    protected FrameworkState createServiceValue(StartContext startContext) throws StartException {
        return this.frameworkState;
    }

    public void stop(StopContext context) {
        this.getBundleManagerPlugin().injectedFramework.uninject();
    }

    private class FrameworkCreated
    extends AbstractIntegrationService<BundleContext> {
        final InjectedValue<BundleContext> injectedBundleContext;

        private FrameworkCreated() {
            super(Services.FRAMEWORK_CREATE);
            this.injectedBundleContext = new InjectedValue();
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(IntegrationServices.SYSTEM_CONTEXT_INTERNAL, BundleContext.class, this.injectedBundleContext);
            builder.addDependency(IntegrationServices.FRAMEWORK_CREATE_INTERNAL);
            builder.setInitialMode(FrameworkCreate.this.initialMode);
        }

        @Override
        protected BundleContext createServiceValue(StartContext startContext) throws StartException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }
}

