/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.BundleException;

final class BootstrapBundlesInstallPlugin
extends BootstrapBundlesInstall<Void> {
    BootstrapBundlesInstallPlugin() {
        super(IntegrationServices.BOOTSTRAP_BUNDLES);
    }

    @Override
    public void start(StartContext context) throws StartException {
        URL url;
        ServiceTarget serviceTarget = context.getChildTarget();
        ArrayList<URL> autoInstall = new ArrayList<URL>();
        ArrayList<URL> autoStart = new ArrayList<URL>();
        String propValue = (String)this.getBundleManager().getProperty("org.jboss.osgi.auto.install");
        if (propValue != null) {
            for (String path : propValue.split(",")) {
                url = this.toURL(path.trim());
                if (url == null) continue;
                autoInstall.add(url);
            }
        }
        if ((propValue = (String)this.getBundleManager().getProperty("org.jboss.osgi.auto.start")) != null) {
            for (String path : propValue.split(",")) {
                url = this.toURL(path.trim());
                if (url == null) continue;
                autoStart.add(url);
            }
        }
        autoInstall.addAll(autoStart);
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (URL url2 : autoInstall) {
            try {
                BundleInfo info = BundleInfo.createBundleInfo((URL)url2);
                Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
                dep.setAutoStart(autoStart.contains(url2));
                deployments.add(dep);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, url2.toExternalForm());
            }
        }
        this.installBootstrapBundles(serviceTarget, deployments);
    }

    private URL toURL(String path) {
        URL pathURL = null;
        StringPropertyReplacer.PropertyProvider provider = new StringPropertyReplacer.PropertyProvider(){

            public String getProperty(String key) {
                return (String)BootstrapBundlesInstallPlugin.this.getBundleManager().getProperty(key);
            }
        };
        String realPath = StringPropertyReplacer.replaceProperties((String)path, (StringPropertyReplacer.PropertyProvider)provider);
        try {
            pathURL = new URL(realPath);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (pathURL == null) {
            try {
                File file = new File(realPath);
                if (file.exists()) {
                    pathURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException ex) {
                throw FrameworkMessages.MESSAGES.illegalArgumentInvalidPath(ex, realPath);
            }
        }
        if (pathURL == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidPath(null, realPath);
        }
        return pathURL;
    }
}

