/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.plugins.platform.content.yum.Content;
import org.rhq.plugins.platform.content.yum.PrimaryMD5;
import org.rhq.plugins.platform.content.yum.Request;

public class Primary
extends Content {
    private static ReentrantLock lock = new ReentrantLock();
    private final PrimaryMD5 mymd5 = new PrimaryMD5(this.context().getTemporaryDirectory());

    public Primary(Request request) {
        super(request);
    }

    @Override
    public InputStream openStream() throws Exception {
        return new FileInputStream(this.file());
    }

    @Override
    public void writeHeader(OutputStream ostr) throws Exception {
        PrintWriter writer = new PrintWriter(ostr);
        writer.printf("HTTP/1.1 200\n", new Object[0]);
        writer.println("Server: Ackbar (Red Hat)");
        writer.println("Content-Type: text/xml; charset=utf-8");
        writer.printf("Content-Length: %d\n\n", this.length());
        writer.flush();
    }

    @Override
    public void writeContent(OutputStream ostr) throws Exception {
        InputStream istr = this.openStream();
        this.transfer(istr, ostr);
        istr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.mymd5.delete();
        lock.lock();
        try {
            new File(this.filepath()).delete();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws Exception {
        lock.lock();
        try {
            long l = this.file().length();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    File file() throws Exception {
        lock.lock();
        try {
            File file = new File(this.filepath());
            if (!file.exists()) {
                this.create(file);
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            this.delete();
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    boolean stale() {
        try {
            String md5 = this.context().getResourceSubscriptionMD5();
            if (!this.mymd5.matches(md5)) {
                return true;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error validating/writing md5", (Throwable)e);
            return true;
        }
        return false;
    }

    private String filepath() {
        return new File(this.context().getTemporaryDirectory(), "primary.xml").getAbsolutePath();
    }

    private void create(File file) throws IOException {
        long start = System.currentTimeMillis();
        PrintWriter writer = new PrintWriter(file);
        Pattern ptn = Pattern.compile("(href=\")([^\"]+)(\")");
        PageControl pc = new PageControl();
        pc.setPageNumber(0);
        pc.setPageSize(200);
        this.mymd5.write(this.context().getResourceSubscriptionMD5());
        while (true) {
            PageList<PackageVersionMetadataComposite> list = this.context().getPackageVersionMetadata(pc);
            if (pc.getPageNumber() == 0) {
                writer.append("<metadata xmlns=\"http://linux.duke.edu/metadata/common\" ");
                writer.append("xmlns:rpm=\"http://linux.duke.edu/metadata/rpm\" ");
                writer.printf("packages=\"%d\">\n", list.getTotalSize());
            }
            if (list.size() < 1) break;
            for (PackageVersionMetadataComposite p : list) {
                byte[] metadata = p.getMetadata();
                String pkg = new String(this.gunzip(metadata));
                Matcher m = ptn.matcher(pkg);
                m.find();
                StringBuilder sb = new StringBuilder(pkg);
                sb.insert(m.end(2), Primary.toArgs(p.getPackageDetailsKey()));
                writer.append(sb.toString());
            }
            pc.setPageNumber(pc.getPageNumber() + 1);
        }
        writer.append("</metadata>");
        writer.flush();
        writer.close();
        long duration = System.currentTimeMillis() - start;
        this.log.info((Object)("file: " + file + " created: " + duration + " (ms)"));
    }

    private String gunzip(byte[] input) {
        try {
            int bytesRead;
            GZIPInputStream zipped = new GZIPInputStream((InputStream)new ByteArrayInputStream(input), this.bfr.length);
            ByteArrayOutputStream unzipped = new ByteArrayOutputStream();
            while ((bytesRead = ((InputStream)zipped).read(this.bfr)) != -1) {
                unzipped.write(this.bfr, 0, bytesRead);
            }
            return unzipped.toString();
        }
        catch (Exception e) {
            this.log.debug((Object)"compressed data expected, gunzip failed", (Throwable)e);
            return new String(input);
        }
    }

    static String toArgs(PackageDetailsKey key) {
        StringBuilder sb = new StringBuilder("?");
        sb.append("type=");
        sb.append(key.getPackageTypeName());
        sb.append(",name=");
        sb.append(key.getName());
        sb.append(",ver=");
        sb.append(key.getVersion());
        sb.append(",arch=");
        sb.append(key.getArchitectureName());
        return sb.toString();
    }

    static PackageDetailsKey toKey(Map<String, String> args) {
        return new PackageDetailsKey(args.get("name"), args.get("ver"), args.get("type"), args.get("arch"));
    }
}

