/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.server.impl.QuorumManager;

public abstract class LiveNodeLocator
implements ClusterTopologyListener {
    private QuorumManager quorumManager;

    public LiveNodeLocator(QuorumManager quorumManager) {
        this.quorumManager = quorumManager;
    }

    public abstract void locateNode() throws HornetQException;

    public abstract Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration();

    public abstract String getNodeID();

    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        if (alreadyReplicating) {
            this.quorumManager.notifyAlreadyReplicating();
        } else {
            this.quorumManager.notifyRegistrationFailed();
        }
    }

    public void connectToCluster(ServerLocatorInternal serverLocator) throws HornetQException {
        serverLocator.connect();
    }
}

