/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.impl.SimpleWaitIOCallback;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.ExecutorFactory;

public class OperationContextImpl
implements OperationContext {
    private static final ThreadLocal<OperationContext> threadLocalContext = new ThreadLocal();
    private List<TaskHolder> tasks;
    private int minimalStore = Integer.MAX_VALUE;
    private int minimalReplicated = Integer.MAX_VALUE;
    private int minimalPage = Integer.MAX_VALUE;
    private final AtomicInteger storeLineUp = new AtomicInteger(0);
    private final AtomicInteger replicationLineUp = new AtomicInteger(0);
    private final AtomicInteger pageLineUp = new AtomicInteger(0);
    private int stored = 0;
    private int replicated = 0;
    private int paged = 0;
    private int errorCode = -1;
    private String errorMessage = null;
    private final Executor executor;
    private final AtomicInteger executorsPending = new AtomicInteger(0);

    public static void clearContext() {
        threadLocalContext.set(null);
    }

    public static final OperationContext getContext() {
        return OperationContextImpl.getContext(null);
    }

    public static OperationContext getContext(ExecutorFactory executorFactory) {
        OperationContext token = threadLocalContext.get();
        if (token == null) {
            if (executorFactory == null) {
                return null;
            }
            token = new OperationContextImpl(executorFactory.getExecutor());
            threadLocalContext.set(token);
        }
        return token;
    }

    public static void setContext(OperationContext context) {
        threadLocalContext.set(context);
    }

    public OperationContextImpl(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void pageSyncLineUp() {
        this.pageLineUp.incrementAndGet();
    }

    @Override
    public synchronized void pageSyncDone() {
        ++this.paged;
        this.checkTasks();
    }

    public void storeLineUp() {
        this.storeLineUp.incrementAndGet();
    }

    @Override
    public void replicationLineUp() {
        this.replicationLineUp.incrementAndGet();
    }

    @Override
    public synchronized void replicationDone() {
        ++this.replicated;
        this.checkTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnCompletion(IOAsyncTask completion) {
        if (this.errorCode != -1) {
            completion.onError(this.errorCode, this.errorMessage);
            return;
        }
        boolean executeNow = false;
        OperationContextImpl operationContextImpl = this;
        synchronized (operationContextImpl) {
            if (this.tasks == null) {
                this.tasks = new LinkedList<TaskHolder>();
                this.minimalReplicated = this.replicationLineUp.intValue();
                this.minimalStore = this.storeLineUp.intValue();
                this.minimalPage = this.pageLineUp.intValue();
            }
            if (this.replicationLineUp.intValue() == this.replicated && this.storeLineUp.intValue() == this.stored && this.pageLineUp.intValue() == this.paged) {
                if (this.executorsPending.get() == 0) {
                    executeNow = true;
                } else {
                    this.execute(completion);
                }
            } else {
                this.tasks.add(new TaskHolder(completion));
            }
        }
        if (executeNow) {
            completion.done();
        }
    }

    public synchronized void done() {
        ++this.stored;
        this.checkTasks();
    }

    private void checkTasks() {
        if (this.stored >= this.minimalStore && this.replicated >= this.minimalReplicated && this.paged >= this.minimalPage) {
            Iterator<TaskHolder> iter = this.tasks.iterator();
            while (iter.hasNext()) {
                TaskHolder holder = iter.next();
                if (this.stored < holder.storeLined || this.replicated < holder.replicationLined || this.paged < holder.pageLined) break;
                this.execute(holder.task);
                iter.remove();
            }
        }
    }

    private void execute(final IOAsyncTask task) {
        this.executorsPending.incrementAndGet();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        OperationContextImpl.clearContext();
                        task.done();
                    }
                    finally {
                        OperationContextImpl.this.executorsPending.decrementAndGet();
                    }
                }
            });
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.errorExecutingIOAsyncTask(e);
            this.executorsPending.decrementAndGet();
            task.onError(HornetQExceptionType.INTERNAL_ERROR.getCode(), "It wasn't possible to complete IO operation - " + e.getMessage());
        }
    }

    public void complete() {
    }

    public synchronized void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        if (this.tasks != null) {
            Iterator<TaskHolder> iter = this.tasks.iterator();
            while (iter.hasNext()) {
                TaskHolder holder = iter.next();
                holder.task.onError(errorCode, errorMessage);
                iter.remove();
            }
        }
    }

    @Override
    public void waitCompletion() throws Exception {
        this.waitCompletion(0L);
    }

    @Override
    public boolean waitCompletion(long timeout) throws Exception {
        SimpleWaitIOCallback waitCallback = new SimpleWaitIOCallback();
        this.executeOnCompletion((IOAsyncTask)waitCallback);
        this.complete();
        if (timeout == 0L) {
            waitCallback.waitCompletion();
            return true;
        }
        return waitCallback.waitCompletion(timeout);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.tasks != null) {
            for (TaskHolder hold : this.tasks) {
                buffer.append("Task = " + hold + "\n");
            }
        }
        return "OperationContextImpl [" + this.hashCode() + "] [minimalStore=" + this.minimalStore + ", storeLineUp=" + this.storeLineUp + ", stored=" + this.stored + ", minimalReplicated=" + this.minimalReplicated + ", replicationLineUp=" + this.replicationLineUp + ", replicated=" + this.replicated + ", paged=" + this.paged + ", minimalPage=" + this.minimalPage + ", pageLineUp=" + this.pageLineUp + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", executorsPending=" + this.executorsPending + ", executor=" + this.executor + "]" + buffer.toString();
    }

    final class TaskHolder {
        final int storeLined;
        final int replicationLined;
        final int pageLined;
        final IOAsyncTask task;

        public String toString() {
            return "TaskHolder [storeLined=" + this.storeLined + ", replicationLined=" + this.replicationLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        TaskHolder(IOAsyncTask task) {
            this.storeLined = OperationContextImpl.this.storeLineUp.intValue();
            this.replicationLined = OperationContextImpl.this.replicationLineUp.intValue();
            this.pageLined = OperationContextImpl.this.pageLineUp.intValue();
            this.task = task;
        }
    }
}

