/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.helper;

import java.util.LinkedList;
import javax.el.ValueExpression;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.gui.util.FacesExpressionUtility;

public class ConfigurationExpressionUtility {
    public static ValueExpression createValueExpressionForPropertyDefiniton(String configurationDefinitionExpressionString, PropertyDefinition propertyDefinition) {
        StringBuilder stringBuilder = new StringBuilder("#{");
        stringBuilder.append(FacesExpressionUtility.unwrapExpressionString(configurationDefinitionExpressionString));
        LinkedList<PropertyDefinition> propertyDefinitionHierarchy = ConfigurationExpressionUtility.getPropertyDefinitionHierarchy(propertyDefinition);
        for (PropertyDefinition subPropertyDefinition : propertyDefinitionHierarchy) {
            PropertyDefinition parentPropertyDefinition = ConfigurationExpressionUtility.getParentPropertyDefinition(subPropertyDefinition);
            stringBuilder.append(".");
            if (parentPropertyDefinition == null || parentPropertyDefinition instanceof PropertyDefinitionMap) {
                stringBuilder.append("propertyDefinitions['").append(subPropertyDefinition.getName()).append("']");
                continue;
            }
            stringBuilder.append("memberDefinition");
        }
        stringBuilder.append("}");
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression(stringBuilder.toString(), PropertyDefinition.class);
        return valueExpression;
    }

    public static LinkedList<PropertyDefinition> getPropertyDefinitionHierarchy(PropertyDefinition propertyDefinition) {
        LinkedList<PropertyDefinition> propertyHierarchy = new LinkedList<PropertyDefinition>();
        PropertyDefinition parentPropertyDefinition = propertyDefinition;
        while ((parentPropertyDefinition = ConfigurationExpressionUtility.getParentPropertyDefinition(parentPropertyDefinition)) != null) {
            propertyHierarchy.addFirst(parentPropertyDefinition);
        }
        propertyHierarchy.add(propertyDefinition);
        return propertyHierarchy;
    }

    @Nullable
    public static PropertyDefinition getParentPropertyDefinition(PropertyDefinition property) {
        Object parentPropertyDefinition = property.getParentPropertyListDefinition() != null ? property.getParentPropertyListDefinition() : (property.getParentPropertyMapDefinition() != null ? property.getParentPropertyMapDefinition() : null);
        return parentPropertyDefinition;
    }
}

