/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.util.StringTokenizer;

public class SchemaVersion
implements Comparable {
    public static final String DEV_VERSION = "@@@DB_SCHEMA_VERSION@@@";
    public static final String LATEST_VERSION = "LATEST";
    private String versionString = null;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int patchVersion = 0;
    private boolean isLatest = false;

    public SchemaVersion(String version_string) throws IllegalArgumentException {
        this.versionString = version_string;
        if (this.versionString == null || this.versionString.equals(DEV_VERSION)) {
            this.versionString = LATEST_VERSION;
        }
        if (this.versionString.equalsIgnoreCase(LATEST_VERSION)) {
            this.isLatest = true;
            this.majorVersion = 1234567890;
            this.minorVersion = 1234567890;
            this.patchVersion = 1234567890;
        } else {
            this.isLatest = false;
            StringTokenizer strtok = new StringTokenizer(this.versionString, ".");
            if (!strtok.hasMoreTokens()) {
                throw new IllegalArgumentException("Invalid version: " + this.versionString);
            }
            this.majorVersion = this.parseInt(strtok.nextToken());
            if (strtok.hasMoreTokens()) {
                this.minorVersion = this.parseInt(strtok.nextToken());
                if (strtok.hasMoreTokens()) {
                    this.patchVersion = this.parseInt(strtok.nextToken());
                }
            }
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public boolean getIsLatest() {
        return this.isLatest;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("o==null");
        }
        if (!(o instanceof SchemaVersion)) {
            throw new IllegalArgumentException(o.getClass().getName() + " != " + SchemaVersion.class.getName());
        }
        SchemaVersion v = (SchemaVersion)o;
        int num = this.getMajorVersion() != v.getMajorVersion() ? this.getMajorVersion() - v.getMajorVersion() : (this.getMinorVersion() != v.getMinorVersion() ? this.getMinorVersion() - v.getMinorVersion() : this.getPatchVersion() - v.getPatchVersion());
        return num;
    }

    private int parseInt(String number_string) throws IllegalArgumentException {
        try {
            return Integer.parseInt(number_string);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe);
        }
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SchemaVersion) {
            SchemaVersion compare_me = (SchemaVersion)o;
            return this.majorVersion == compare_me.majorVersion && this.minorVersion == compare_me.minorVersion && this.patchVersion == compare_me.patchVersion;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + this.patchVersion;
        return result;
    }

    public boolean between(SchemaVersion start_exclusive, SchemaVersion end_inclusive) {
        return this.compareTo(start_exclusive) > 0 && this.compareTo(end_inclusive) <= 0;
    }
}

