/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.modules.ConcurrentClassLoader;

public class TempClassLoader
extends ConcurrentClassLoader {
    private final ClassLoader delegate;

    TempClassLoader(ClassLoader delegate) {
        super(null);
        this.delegate = delegate;
    }

    protected Class<?> findClass(String name, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        Class loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        if (name.startsWith("javax.")) {
            return Class.forName(name, resolve, this.delegate);
        }
        InputStream resource = this.delegate.getResourceAsStream(name.replace('.', '/') + ".class");
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = resource.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, i);
            }
            buffer = baos.toByteArray();
            Class clazz = this.defineClass(name, buffer, 0, buffer.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException e) {}
        }
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return this.delegate.getResource(name);
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return this.delegate.getResources(name);
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        return this.delegate.getResourceAsStream(name);
    }
}

