/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayer;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.menu.PermissionsAdapter;
import net.sf.navigator.util.MessageResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMenuDisplayer
implements MenuDisplayer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected String name;
    protected MessageResources displayStrings;
    protected JspWriter out;
    protected String target;
    protected PermissionsAdapter permissionsAdapter;
    protected MenuDisplayerMapping mapping;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfig() {
        String config = null;
        if (this.displayStrings != null) {
            config = this.displayStrings.getConfig();
        }
        return config;
    }

    public void setConfig(String config) {
        this.displayStrings = MessageResources.getMessageResources(config);
    }

    public String getTarget() {
        return this.target;
    }

    protected String getTarget(MenuComponent menu) {
        String theTarget = null;
        if (this.target == null) {
            if (menu.getTarget() != null) {
                theTarget = menu.getTarget();
            }
        } else {
            theTarget = this.target;
        }
        return theTarget;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public PermissionsAdapter getPermissionsAdapter() {
        return this.permissionsAdapter;
    }

    public void setPermissionsAdapter(PermissionsAdapter permissionsAdapter) {
        this.permissionsAdapter = permissionsAdapter;
    }

    public void init(PageContext pageContext, MenuDisplayerMapping mapping) {
        this.out = pageContext.getOut();
        this.mapping = mapping;
    }

    public abstract void display(MenuComponent var1) throws JspException, IOException;

    public void end(PageContext pageContext) {
    }

    public boolean isAllowed(MenuComponent menu) {
        if (this.permissionsAdapter == null) {
            return true;
        }
        return this.permissionsAdapter.isAllowed(menu);
    }
}

