/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.remoting.impl.netty.HornetQChannelHandler;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder2;
import org.hornetq.core.remoting.impl.netty.NettyConnection;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.AbstractConnector;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.VersionLoader;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.VirtualExecutorService;

public class NettyConnector
extends AbstractConnector {
    public static final String JAVAX_KEYSTORE_PATH_PROP_NAME = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.keyStorePassword";
    private ClientSocketChannelFactory channelFactory;
    private ClientBootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpMaxClientIdleTime;
    private final long httpClientIdleScanPeriod;
    private final boolean httpRequiresSessionId;
    private final boolean useNio;
    private final boolean useServlet;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final long batchDelay;
    private final ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private final String servletPath;
    private final int nioRemotingThreads;
    private final VirtualExecutorService virtualExecutor;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        super(configuration);
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.nullListener();
        }
        if (handler == null) {
            throw HornetQClientMessageBundle.BUNDLE.nullHandler();
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("ssl-enabled", false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty("http-enabled", false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty("servlet-path", "/messaging/HornetQServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty("http-client-idle-time", 500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty("http-client-idle-scan-period", 500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty("http-requires-session-id", false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty("use-nio", false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty("nio-remoting-threads", -1, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty("use-servlet", false, configuration);
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty("key-store-path", "hornetq.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("key-store-password", "secureexample", configuration, "hornetq.usemaskedpassword", "hornetq.usemaskedpassword");
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcp-no-delay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcp-send-buffer-size", 32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcp-receive-buffer-size", 32768, configuration);
        this.batchDelay = ConfigurationHelper.getLongProperty("batch-delay", 0L, configuration);
        this.closeExecutor = closeExecutor;
        this.virtualExecutor = new VirtualExecutorService(threadPool);
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public String toString() {
        return "NettyConnector [host=" + this.host + ", port=" + this.port + ", httpEnabled=" + this.httpEnabled + ", useServlet=" + this.useServlet + ", servletPath=" + this.servletPath + ", sslEnabled=" + this.sslEnabled + ", useNio=" + this.useNio + "]";
    }

    @Override
    public synchronized void start() {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        if (this.useNio) {
            int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
            this.channelFactory = new NioClientSocketChannelFactory((Executor)this.virtualExecutor, (Executor)this.virtualExecutor, threadsToUse);
        } else {
            this.channelFactory = new OioClientSocketChannelFactory((Executor)this.virtualExecutor);
        }
        if (this.useServlet) {
            ClientSocketChannelFactory proxyChannelFactory = this.channelFactory;
            this.channelFactory = new HttpTunnelingClientSocketChannelFactory(proxyChannelFactory);
        }
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
        this.bootstrap.setOption("tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.channelGroup = new DefaultChannelGroup("hornetq-connector");
        if (this.sslEnabled) {
            try {
                String realKeyStorePath = this.keyStorePath;
                String realKeyStorePassword = this.keyStorePassword;
                if (System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME) != null) {
                    realKeyStorePath = System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME) != null) {
                    realKeyStorePassword = System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME);
                }
                context = SSLSupport.getInstance(true, realKeyStorePath, realKeyStorePassword, null, null);
            }
            catch (Exception e) {
                this.close();
                IllegalStateException ise = new IllegalStateException("Unable to create NettyConnector for " + this.host);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        if (context != null && this.useServlet) {
            this.bootstrap.setOption("sslContext", context);
        }
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ArrayList<Object> handlers = new ArrayList<Object>();
                if (NettyConnector.this.sslEnabled && !NettyConnector.this.useServlet) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(true);
                    engine.setWantClientAuth(true);
                    SslHandler handler = new SslHandler(engine);
                    handlers.add(handler);
                }
                if (NettyConnector.this.httpEnabled) {
                    handlers.add(new HttpRequestEncoder());
                    handlers.add(new HttpResponseDecoder());
                    handlers.add(new HttpChunkAggregator(Integer.MAX_VALUE));
                    handlers.add((Object)new HttpHandler());
                }
                handlers.add((Object)new HornetQFrameDecoder2());
                handlers.add((Object)new HornetQClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener()));
                ChannelPipeline pipeline = Channels.pipeline((ChannelHandler[])handlers.toArray(new ChannelHandler[handlers.size()]));
                return pipeline;
            }
        });
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        if (!"3.6.2.Final-c0d783c".equals(VersionLoader.getVersion().getNettyVersion())) {
            HornetQClientLogger.LOGGER.unexpectedNettyVersion(VersionLoader.getVersion().getNettyVersion(), "3.6.2.Final-c0d783c");
        }
        HornetQClientLogger.LOGGER.debug("Started Netty Connector version 3.6.2.Final-c0d783c");
    }

    @Override
    public synchronized void close() {
        if (this.channelFactory == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    @Override
    public boolean isStarted() {
        return this.channelFactory != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection createConnection() {
        Inet6Address inet6Address;
        InetSocketAddress remoteDestination;
        InetAddress inetAddress;
        if (this.channelFactory == null) {
            return null;
        }
        if (this.useServlet) {
            try {
                URI uri = new URI("http", null, this.host, this.port, this.servletPath, null, null);
                this.bootstrap.setOption("serverName", (Object)uri.getHost());
                this.bootstrap.setOption("serverPath", (Object)uri.getRawPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if ((inetAddress = (remoteDestination = new InetSocketAddress(this.host, this.port)).getAddress()) instanceof Inet6Address && (inet6Address = (Inet6Address)inetAddress).getScopeId() != 0) {
            try {
                remoteDestination = new InetSocketAddress(InetAddress.getByAddress(inet6Address.getAddress()), remoteDestination.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        HornetQClientLogger.LOGGER.debug("Remote destination: " + remoteDestination);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)remoteDestination);
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch = future.getChannel();
            SslHandler sslHandler = (SslHandler)ch.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                ChannelFuture handshakeFuture = sslHandler.handshake();
                if (!handshakeFuture.awaitUninterruptibly(30000L)) {
                    handshakeFuture.setFailure((Throwable)new SSLException("Handshake was not completed in 30 seconds"));
                    ch.close().awaitUninterruptibly();
                    return null;
                }
                if (!handshakeFuture.isSuccess()) {
                    ch.close().awaitUninterruptibly();
                    return null;
                }
                ((HornetQChannelHandler)ch.getPipeline().get(HornetQChannelHandler.class)).active = true;
            } else {
                ((HornetQChannelHandler)ch.getPipeline().get(HornetQChannelHandler.class)).active = true;
            }
            Listener connectionListener = new Listener();
            NettyConnection conn = new NettyConnection(this.configuration, ch, connectionListener, !this.httpEnabled && this.batchDelay > 0L, false);
            connectionListener.connectionCreated(null, conn, ProtocolType.CORE);
            return conn;
        }
        Throwable t = future.getCause();
        if (t != null && !(t instanceof ConnectException)) {
            HornetQClientLogger.LOGGER.errorCreatingNettyConnection(future.getCause());
        }
        return null;
    }

    @Override
    public boolean isEquivalent(Map<String, Object> configuration) {
        String host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        Integer port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        if (!port.equals(this.port)) {
            return false;
        }
        if (host.equals(this.host)) {
            return true;
        }
        boolean result = false;
        try {
            InetAddress inetAddr1 = InetAddress.getByName(host);
            InetAddress inetAddr2 = InetAddress.getByName(this.host);
            String ip1 = inetAddr1.getHostAddress();
            String ip2 = inetAddr2.getHostAddress();
            HornetQClientLogger.LOGGER.debug(this + " host 1: " + host + " ip address: " + ip1 + " host 2: " + this.host + " ip address: " + ip2);
            result = ip1.equals(ip2);
        }
        catch (UnknownHostException e) {
            HornetQClientLogger.LOGGER.error("Cannot resolve host", e);
        }
        return result;
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyConnector.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(HornetQComponent component, Connection connection, ProtocolType protocol) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw HornetQClientMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                NettyConnector.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(final Object connectionID, final HornetQException me) {
            NettyConnector.this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }

    class HttpHandler
    extends SimpleChannelHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private HttpIdleTimer task;
        private final String url;
        private final FutureLatch handShakeFuture = new FutureLatch();
        private boolean active = false;
        private boolean handshaking = false;
        private final CookieDecoder cookieDecoder = new CookieDecoder();
        private String cookie;
        private final CookieEncoder cookieEncoder = new CookieEncoder(false);

        public HttpHandler() throws Exception {
            this.url = new URI("http", null, NettyConnector.this.host, NettyConnector.this.port, NettyConnector.this.servletPath, null, null).toString();
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
            this.channel = e.getChannel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.task = new HttpIdleTimer();
                ScheduledFuture<?> future = NettyConnector.this.scheduledThreadPool.scheduleAtFixedRate(this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod, TimeUnit.MILLISECONDS);
                this.task.setFuture(future);
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.task != null) {
                this.task.close();
            }
            super.channelClosed(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            HttpResponse response = (HttpResponse)e.getMessage();
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                Set cookieMap = this.cookieDecoder.decode(response.getHeader("Set-Cookie"));
                for (Cookie cookie : cookieMap) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.cookieEncoder.addCookie(cookie);
                    this.cookie = this.cookieEncoder.encode();
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            UpstreamMessageEvent event = new UpstreamMessageEvent(e.getChannel(), (Object)response.getContent(), e.getRemoteAddress());
            this.waitingGet = false;
            ctx.sendUpstream((ChannelEvent)event);
        }

        public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (e.getMessage() instanceof ChannelBuffer) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url);
                if (this.cookie != null) {
                    httpRequest.addHeader("Cookie", (Object)this.cookie);
                }
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                httpRequest.setContent(buf);
                httpRequest.addHeader("Content-Length", (Object)String.valueOf(buf.writerIndex()));
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)httpRequest, (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            } else {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)e.getMessage(), (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        private class HttpIdleTimer
        implements Runnable {
            private boolean closed = false;
            private Future<?> future;

            private HttpIdleTimer() {
            }

            @Override
            public synchronized void run() {
                if (this.closed) {
                    return;
                }
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.write((Object)httpRequest);
                }
            }

            public synchronized void setFuture(Future<?> future) {
                this.future = future;
            }

            public void close() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.closed = true;
            }
        }
    }

    private static final class HornetQClientChannelHandler
    extends HornetQChannelHandler {
        HornetQClientChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }
    }
}

