/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class NamingBindingAdd
extends AbstractAddStepHandler {
    private static final String[] GLOBAL_NAMESPACES = new String[]{"java:global", "java:jboss", "java:/"};
    static final NamingBindingAdd INSTANCE = new NamingBindingAdd();

    private NamingBindingAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        this.installRuntimeServices(context, name, model, verificationHandler, newControllers);
    }

    void installRuntimeServices(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean allowed = false;
        for (String ns : GLOBAL_NAMESPACES) {
            if (!name.startsWith(ns)) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            throw NamingMessages.MESSAGES.invalidNamespaceForBinding(name, Arrays.toString(GLOBAL_NAMESPACES));
        }
        BindingType type = BindingType.forName(NamingBindingResourceDefinition.BINDING_TYPE.resolveModelAttribute(context, model).asString());
        if (type == BindingType.SIMPLE) {
            this.installSimpleBinding(context, name, model, verificationHandler, newControllers);
        } else if (type == BindingType.OBJECT_FACTORY) {
            this.installObjectFactory(context, name, model, verificationHandler, newControllers);
        } else if (type == BindingType.LOOKUP) {
            this.installLookup(context, name, model, verificationHandler, newControllers);
        } else {
            throw NamingMessages.MESSAGES.unknownBindingType(type.toString());
        }
    }

    void installSimpleBinding(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String value = NamingBindingResourceDefinition.VALUE.resolveModelAttribute(context, model).asString();
        String type = model.hasDefined("type") ? NamingBindingResourceDefinition.TYPE.resolveModelAttribute(context, model).asString() : null;
        Object bindValue = this.coerceToType(value, type);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name, bindValue);
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value<?>)new ImmediateValue(bindValue)));
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    void installObjectFactory(OperationContext context, final String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ObjectFactory objectFactoryClassInstance;
        Module module;
        ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)NamingBindingResourceDefinition.MODULE.resolveModelAttribute(context, model).asString());
        String className = NamingBindingResourceDefinition.CLASS.resolveModelAttribute(context, model).asString();
        try {
            module = Module.getBootModuleLoader().loadModule(moduleID);
        }
        catch (ModuleLoadException e) {
            throw NamingMessages.MESSAGES.couldNotLoadModule(moduleID);
        }
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)module.getClassLoader());
            Class clazz = module.getClassLoader().loadClass(className);
            objectFactoryClassInstance = (ObjectFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw NamingMessages.MESSAGES.couldNotLoadClassFromModule(className, moduleID);
        }
        catch (InstantiationException e) {
            throw NamingMessages.MESSAGES.couldNotInstantiateClassInstanceFromModule(className, moduleID);
        }
        catch (IllegalAccessException e) {
            throw NamingMessages.MESSAGES.couldNotInstantiateClassInstanceFromModule(className, moduleID);
        }
        catch (ClassCastException e) {
            throw NamingMessages.MESSAGES.notAnInstanceOfObjectFactory(className, moduleID);
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        final Hashtable<String, String> environment = this.getObjectFactoryEnvironment(context, model);
        BinderService binderService = new BinderService(name, objectFactoryClassInstance);
        binderService.getManagedObjectInjector().inject((Object)new ContextListAndJndiViewManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = objectFactoryClassInstance.getObjectInstance(name, null, null, environment);
                    return new ValueManagedReference((Value<Object>)new ImmediateValue(value));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInstanceClassName() {
                ClassLoader cl = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(objectFactoryClassInstance.getClass().getClassLoader());
                    Object value = this.getReference().getInstance();
                    String string = value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
                    return string;
                }
                finally {
                    SecurityActions.setContextClassLoader(cl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getJndiViewInstanceValue() {
                ClassLoader cl = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(objectFactoryClassInstance.getClass().getClassLoader());
                    String string = String.valueOf(this.getReference().getInstance());
                    return string;
                }
                finally {
                    SecurityActions.setContextClassLoader(cl);
                }
            }
        });
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    private Hashtable<String, String> getObjectFactoryEnvironment(OperationContext context, ModelNode model) throws OperationFailedException {
        Map resolvedModelAttribute = NamingBindingResourceDefinition.OBJECT_FACTORY_ENV.unwrap(context, model);
        Hashtable<String, String> environment = new Hashtable<String, String>(resolvedModelAttribute);
        return environment;
    }

    void installLookup(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final String lookup = NamingBindingResourceDefinition.LOOKUP.resolveModelAttribute(context, model).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name);
        binderService.getManagedObjectInjector().inject((Object)new ContextListAndJndiViewManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = new InitialContext().lookup(lookup);
                    return new ValueManagedReference((Value<Object>)new ImmediateValue(value));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getInstanceClassName() {
                Object value = this.getReference().getInstance();
                return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
            }

            @Override
            public String getJndiViewInstanceValue() {
                return String.valueOf(this.getReference().getInstance());
            }
        });
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    private Object coerceToType(String value, String type) throws OperationFailedException {
        if (type == null || type.isEmpty() || type.equals(String.class.getName())) {
            return value;
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals("byte") || type.equals("java.lang.Byte")) {
            return Byte.parseByte(value);
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            return Short.parseShort(value);
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            return Integer.parseInt(value);
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            return Long.parseLong(value);
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            return Double.parseDouble(value);
        }
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(URL.class.getName())) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw NamingMessages.MESSAGES.unableToTransformURLBindingValue(value, e);
            }
        }
        throw NamingMessages.MESSAGES.unsupportedSimpleBindingType(type);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        BindingType type = BindingType.forName(operation.require("binding-type").asString());
        NamingBindingResourceDefinition.BINDING_TYPE.validateAndSet(operation, model);
        if (type == BindingType.SIMPLE) {
            NamingBindingResourceDefinition.VALUE.validateAndSet(operation, model);
            NamingBindingResourceDefinition.TYPE.validateAndSet(operation, model);
        } else if (type == BindingType.OBJECT_FACTORY) {
            NamingBindingResourceDefinition.MODULE.validateAndSet(operation, model);
            NamingBindingResourceDefinition.CLASS.validateAndSet(operation, model);
            NamingBindingResourceDefinition.OBJECT_FACTORY_ENV.validateAndSet(operation, model);
        } else if (type == BindingType.LOOKUP) {
            NamingBindingResourceDefinition.LOOKUP.validateAndSet(operation, model);
        } else {
            throw NamingMessages.MESSAGES.unknownBindingType(type.toString());
        }
    }
}

