/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public abstract class UpdatePropertiesHandler {
    private ConsoleWrapper theConsole;

    public UpdatePropertiesHandler(ConsoleWrapper theConsole) {
        this.theConsole = theConsole;
    }

    abstract void persist(String[] var1, File var2) throws IOException;

    abstract String consoleUserMessage(String var1);

    abstract String consoleRolesMessage(String var1);

    abstract String errorMessage(String var1, Throwable var2);

    State update(StateValues stateValues) {
        String[] entry = new String[2];
        try {
            String hash = new UsernamePasswordHashUtil().generateHashedHexURP(stateValues.getUserName(), stateValues.getRealm(), stateValues.getPassword());
            entry[0] = stateValues.getUserName();
            entry[1] = hash;
        }
        catch (NoSuchAlgorithmException e) {
            return new ErrorState(this.theConsole, e.getMessage(), null, stateValues);
        }
        for (File current : stateValues.getPropertiesFiles()) {
            try {
                this.persist(entry, current);
                if (stateValues.isSilent()) continue;
                this.theConsole.printf(this.consoleUserMessage(current.getCanonicalPath()), new Object[0]);
                this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            }
            catch (Exception e) {
                return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
            }
        }
        if (!stateValues.isManagement() && stateValues.getRoles() != null) {
            for (File current : stateValues.getRoleFiles()) {
                String[] role = new String[]{stateValues.getUserName(), stateValues.getRoles()};
                try {
                    this.persist(role, current);
                    if (stateValues.isSilent()) continue;
                    this.theConsole.printf(this.consoleRolesMessage(current.getCanonicalPath()), new Object[0]);
                    this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                }
                catch (IOException e) {
                    return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
                }
            }
        }
        return null;
    }
}

