/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import java.util.jar.Attributes;

public enum JBossProductType {
    AS("JBoss AS", "JBoss Application Server", "default"),
    EAP("JBoss EAP", "JBoss Enterprise Application Platform", "default"),
    EWP("JBoss EWP", "JBoss Enterprise Web Platform", "default"),
    SOA("JBoss SOA-P", "JBoss Enterprise SOA Platform", "default"),
    BRMS("JBoss BRMS", "JBoss Business Rules Management System", "default"),
    EPP("JBoss EPP", "JBoss Enterprise Portal Platform", "default");

    public final String NAME;
    public final String DESCRIPTION;
    public final String DEFAULT_CONFIG_NAME;
    private static final String EAP_IMPLEMENTATION_TITLE = "JBoss [EAP]";
    private static final String EWP_IMPLEMENTATION_TITLE = "JBoss [EWP]";
    private static final String SOA_IMPLEMENTATION_TITLE = "JBoss [SOA]";
    private static final String BRMS_IMPLEMENTATION_TITLE = "JBoss [BRMS]";
    private static final String EPP_IMPLEMENTATION_TITLE = "JBoss [EPP]";

    private JBossProductType(String name, String description, String defaultConfigName) {
        this.NAME = name;
        this.DESCRIPTION = description;
        this.DEFAULT_CONFIG_NAME = defaultConfigName;
    }

    public static JBossProductType determineJBossProductType(Attributes attributes) {
        String implementationTitle;
        JBossProductType result = AS;
        String string = implementationTitle = attributes != null ? attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE) : null;
        if (implementationTitle != null) {
            if (implementationTitle.equalsIgnoreCase(EAP_IMPLEMENTATION_TITLE)) {
                result = EAP;
            } else if (implementationTitle.equalsIgnoreCase(EWP_IMPLEMENTATION_TITLE)) {
                result = EWP;
            } else if (implementationTitle.equalsIgnoreCase(SOA_IMPLEMENTATION_TITLE)) {
                result = SOA;
            } else if (implementationTitle.equalsIgnoreCase(BRMS_IMPLEMENTATION_TITLE)) {
                result = BRMS;
            } else if (implementationTitle.equalsIgnoreCase(EPP_IMPLEMENTATION_TITLE)) {
                result = EPP;
            }
        }
        return result;
    }

    public String toString() {
        return this.NAME;
    }
}

