/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.impl.configuration;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.plugins.jbossas5.adapter.api.AbstractPropertyMapAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;

public abstract class AbstractPropertyMapToCompositeValueAdapter
extends AbstractPropertyMapAdapter
implements PropertyAdapter<PropertyMap, PropertyDefinitionMap> {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void populateMetaValueFromProperty(PropertyMap propMap, MetaValue metaValue, PropertyDefinitionMap propDefMap) {
        CompositeValue compositeValue = (CompositeValue)metaValue;
        for (String mapMemberPropName : propMap.getMap().keySet()) {
            Property mapMemberProp = propMap.get(mapMemberPropName);
            PropertyDefinition mapMemberPropDef = propDefMap.get(mapMemberPropName);
            MetaType mapMemberMetaType = compositeValue.getMetaType().getType(mapMemberPropName);
            if (mapMemberMetaType == null) {
                mapMemberMetaType = SimpleMetaType.STRING;
            }
            PropertyAdapter adapter = PropertyAdapterFactory.getPropertyAdapter(mapMemberMetaType);
            MetaValue mapMemberMetaValue = adapter.convertToMetaValue(mapMemberProp, mapMemberPropDef, mapMemberMetaType);
            this.putValue(compositeValue, mapMemberPropName, mapMemberMetaValue);
        }
    }

    @Override
    public MetaValue convertToMetaValue(PropertyMap propMap, PropertyDefinitionMap propDefMap, MetaType metaType) {
        CompositeValue compositeValue = this.createCompositeValue(propDefMap, metaType);
        this.populateMetaValueFromProperty(propMap, (MetaValue)compositeValue, propDefMap);
        return compositeValue;
    }

    @Override
    public void populatePropertyFromMetaValue(PropertyMap propMap, MetaValue metaValue, PropertyDefinitionMap propDefMap) {
        if (metaValue == null) {
            return;
        }
        CompositeValue compositeValue = (CompositeValue)metaValue;
        Set mapMemberPropNames = compositeValue.getMetaType().keySet();
        for (String mapMemberPropName : mapMemberPropNames) {
            Object mapMemberProp = propMap.get(mapMemberPropName);
            MetaValue mapMemberMetaValue = compositeValue.get(mapMemberPropName);
            MetaType mapMemberMetaType = compositeValue.getMetaType().getType(mapMemberPropName);
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(mapMemberMetaType);
            PropertyDefinition mapMemberPropDef = propDefMap.get(mapMemberPropName);
            if (mapMemberProp != null) continue;
            if (mapMemberPropDef != null) {
                mapMemberProp = propertyAdapter.convertToProperty(mapMemberMetaValue, mapMemberPropDef);
            } else {
                if (!mapMemberMetaType.isSimple() && !mapMemberMetaType.isEnum()) {
                    this.log.debug((Object)("Map member prop [" + mapMemberMetaType + "] is not a simple type - skipping..."));
                    continue;
                }
                mapMemberProp = new PropertySimple(mapMemberPropName, null);
                propertyAdapter.populatePropertyFromMetaValue(mapMemberProp, mapMemberMetaValue, mapMemberPropDef);
            }
            propMap.put(mapMemberProp);
        }
    }

    protected abstract void putValue(CompositeValue var1, String var2, MetaValue var3);

    protected abstract CompositeValue createCompositeValue(PropertyDefinitionMap var1, MetaType var2);
}

