/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.management.client.content;

import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.management.client.content.ManagedDMRContentMessages;
import org.jboss.as.management.client.content.ManagedDMRContentResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ManagedDMRContentStoreHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "store";
    private final AttributeDefinition contentAttribute;
    private final ResourceDescriptionResolver descriptionResolver;

    public ManagedDMRContentStoreHandler(AttributeDefinition contentAttribute, ResourceDescriptionResolver descriptionResolver) {
        this.contentAttribute = contentAttribute;
        this.descriptionResolver = descriptionResolver;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] currentHash;
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        byte[] oldHash = ManagedDMRContentResourceDefinition.HASH.validateOperation(operation).asBytes();
        if (!Arrays.equals(oldHash, currentHash = resource.getModel().get(ManagedDMRContentResourceDefinition.HASH.getName()).asBytes())) {
            throw ManagedDMRContentMessages.MESSAGES.invalidHash(HashUtil.bytesToHexString((byte[])oldHash), PathAddress.pathAddress((ModelNode)operation.require("address")), HashUtil.bytesToHexString((byte[])currentHash));
        }
        ModelNode model = new ModelNode();
        this.contentAttribute.validateAndSet(operation, model);
        resource.writeModel(model);
        context.stepCompleted();
    }

    public ModelNode getModelDescription(Locale locale) {
        DefaultOperationDescriptionProvider delegate = new DefaultOperationDescriptionProvider(OPERATION_NAME, this.descriptionResolver, new AttributeDefinition[]{ManagedDMRContentResourceDefinition.HASH, this.contentAttribute});
        return delegate.getModelDescription(locale);
    }
}

