/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cmp.CmpConfig;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCAuditMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaDataFactory;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedCmpField;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedEntity;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedQuery;
import org.jboss.metadata.ejb.spec.CMPFieldMetaData;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.metadata.ejb.spec.QueryMetaData;

public final class JDBCEntityMetaData {
    private final JDBCApplicationMetaData jdbcApplication;
    private final String dataSourceName;
    private final String dataSourceMappingName;
    private final String entityName;
    private final String abstractSchemaName;
    private final Class<?> entityClass;
    private final Class<?> homeClass;
    private final Class<?> remoteClass;
    private final Class<?> localHomeClass;
    private final Class<?> localClass;
    private final boolean isCMP1x;
    private final String tableName;
    private final boolean createTable;
    private final boolean createTableIfNotExistsSupported;
    private final boolean removeTable;
    private final boolean alterTable;
    private final List<String> tablePostCreateCmd = new ArrayList<String>();
    private final boolean rowLocking;
    private final boolean readOnly;
    private final Integer readTimeOut;
    private final boolean primaryKeyConstraint;
    private final Class<?> primaryKeyClass;
    private final String primaryKeyFieldName;
    private final Map<String, JDBCCMPFieldMetaData> cmpFieldsByName = new HashMap<String, JDBCCMPFieldMetaData>();
    private final List<JDBCCMPFieldMetaData> cmpFields = new ArrayList<JDBCCMPFieldMetaData>();
    private final Map<String, List<String>> loadGroups = new HashMap<String, List<String>>();
    private final String eagerLoadGroup;
    private final List<String> lazyLoadGroups = new ArrayList<String>();
    private final Map<Method, JDBCQueryMetaData> queries = new HashMap<Method, JDBCQueryMetaData>();
    private final JDBCQueryMetaDataFactory queryFactory = new JDBCQueryMetaDataFactory(this);
    private final JDBCReadAheadMetaData readAhead;
    private final boolean cleanReadAheadOnLoad;
    private final int listCacheMax;
    private final int fetchSize;
    private final JDBCEntityCommandMetaData entityCommand;
    private final JDBCOptimisticLockingMetaData optimisticLocking;
    private final JDBCAuditMetaData audit;
    private final Class<?> qlCompiler;
    private final boolean throwRuntimeExceptions;
    private final CmpConfig cmpConfig;

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication) {
        this.jdbcApplication = jdbcApplication;
        this.listCacheMax = 1000;
        this.fetchSize = 0;
        this.entityName = null;
        this.entityClass = null;
        this.primaryKeyClass = null;
        this.isCMP1x = false;
        this.primaryKeyFieldName = null;
        this.homeClass = null;
        this.remoteClass = null;
        this.localHomeClass = null;
        this.localClass = null;
        this.abstractSchemaName = null;
        this.dataSourceName = null;
        this.dataSourceMappingName = null;
        this.tableName = null;
        this.createTable = false;
        this.createTableIfNotExistsSupported = false;
        this.removeTable = false;
        this.alterTable = false;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.rowLocking = false;
        this.primaryKeyConstraint = false;
        this.entityCommand = null;
        this.qlCompiler = null;
        this.throwRuntimeExceptions = false;
        this.eagerLoadGroup = "*";
        this.readAhead = JDBCReadAheadMetaData.DEFAULT;
        this.cleanReadAheadOnLoad = false;
        this.optimisticLocking = null;
        this.audit = null;
        this.cmpConfig = new CmpConfig();
    }

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, EntityBeanMetaData entity) {
        this.jdbcApplication = jdbcApplication;
        this.entityName = entity.getEjbName();
        this.listCacheMax = 1000;
        this.fetchSize = 0;
        ClassLoader classLoader = jdbcApplication.getClassLoader();
        try {
            this.entityClass = classLoader.loadClass(entity.getEjbClass());
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.failedToLoadEntityClass(e);
        }
        try {
            this.primaryKeyClass = classLoader.loadClass(entity.getPrimKeyClass());
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.failedToLoadPkClass(e);
        }
        this.isCMP1x = entity.isCMP1x();
        this.abstractSchemaName = this.isCMP1x ? (entity.getAbstractSchemaName() == null ? this.entityName : entity.getAbstractSchemaName()) : entity.getAbstractSchemaName();
        this.primaryKeyFieldName = entity.getPrimKeyField();
        String home = entity.getHome();
        if (home != null) {
            try {
                this.homeClass = classLoader.loadClass(home);
            }
            catch (ClassNotFoundException e) {
                throw CmpMessages.MESSAGES.failedToLoadHomeClass(e);
            }
            try {
                this.remoteClass = classLoader.loadClass(entity.getRemote());
            }
            catch (ClassNotFoundException e) {
                throw CmpMessages.MESSAGES.failedToLoadRemoteClass(e);
            }
        }
        this.homeClass = null;
        this.remoteClass = null;
        String localHome = entity.getLocalHome();
        if (localHome != null) {
            try {
                this.localHomeClass = classLoader.loadClass(localHome);
            }
            catch (ClassNotFoundException e) {
                throw CmpMessages.MESSAGES.failedToLoadLocalHomeClass(e);
            }
            try {
                this.localClass = classLoader.loadClass(entity.getLocal());
            }
            catch (ClassNotFoundException e) {
                throw CmpMessages.MESSAGES.failedToLoadLocalClass(e);
            }
        }
        if (home == null) {
            throw CmpMessages.MESSAGES.entityMustHaveHome(this.entityName);
        }
        this.localHomeClass = null;
        this.localClass = null;
        this.tableName = this.entityName.replace('.', '_');
        this.dataSourceName = null;
        this.dataSourceMappingName = null;
        this.createTable = false;
        this.createTableIfNotExistsSupported = false;
        this.removeTable = false;
        this.alterTable = false;
        this.rowLocking = false;
        this.primaryKeyConstraint = false;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.qlCompiler = null;
        this.throwRuntimeExceptions = false;
        if (entity.getCmpFields() != null) {
            for (CMPFieldMetaData cmpFieldMetaData : entity.getCmpFields()) {
                JDBCCMPFieldMetaData cmpField = new JDBCCMPFieldMetaData(this, cmpFieldMetaData.getFieldName());
                this.cmpFields.add(cmpField);
                this.cmpFieldsByName.put(cmpFieldMetaData.getFieldName(), cmpField);
            }
        }
        if (this.primaryKeyClass == Object.class) {
            JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this);
            this.cmpFields.add(upkField);
            this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
        }
        this.eagerLoadGroup = "*";
        if (entity.getQueries() != null) {
            for (QueryMetaData queryData : entity.getQueries()) {
                this.queries.putAll(this.queryFactory.createJDBCQueryMetaData(queryData));
            }
        }
        this.readAhead = JDBCReadAheadMetaData.DEFAULT;
        this.cleanReadAheadOnLoad = false;
        this.entityCommand = null;
        this.optimisticLocking = null;
        this.audit = null;
        this.cmpConfig = new CmpConfig();
    }

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, JDBCEntityMetaData defaultValues) {
        this.jdbcApplication = jdbcApplication;
        this.entityName = defaultValues.entityName;
        this.entityClass = defaultValues.entityClass;
        this.primaryKeyClass = defaultValues.primaryKeyClass;
        this.isCMP1x = defaultValues.isCMP1x;
        this.primaryKeyFieldName = defaultValues.primaryKeyFieldName;
        this.homeClass = defaultValues.homeClass;
        this.remoteClass = defaultValues.remoteClass;
        this.localHomeClass = defaultValues.localHomeClass;
        this.localClass = defaultValues.localClass;
        this.abstractSchemaName = defaultValues.abstractSchemaName;
        this.dataSourceName = defaultValues.dataSourceName;
        this.dataSourceMappingName = defaultValues.dataSourceMappingName;
        this.tableName = defaultValues.tableName;
        this.createTable = defaultValues.createTable;
        this.createTableIfNotExistsSupported = defaultValues.createTableIfNotExistsSupported;
        this.removeTable = defaultValues.removeTable;
        this.alterTable = defaultValues.alterTable;
        this.tablePostCreateCmd.addAll(defaultValues.tablePostCreateCmd);
        this.readOnly = defaultValues.readOnly;
        this.readTimeOut = defaultValues.readTimeOut;
        this.rowLocking = defaultValues.rowLocking;
        this.primaryKeyConstraint = defaultValues.primaryKeyConstraint;
        this.listCacheMax = defaultValues.listCacheMax;
        this.fetchSize = defaultValues.fetchSize;
        this.entityCommand = defaultValues.entityCommand;
        this.qlCompiler = defaultValues.qlCompiler;
        this.throwRuntimeExceptions = defaultValues.throwRuntimeExceptions;
        for (JDBCCMPFieldMetaData cmpField : defaultValues.cmpFields) {
            JDBCCMPFieldMetaData newCmpField = new JDBCCMPFieldMetaData(this, cmpField);
            this.cmpFields.add(cmpField);
            this.cmpFieldsByName.put(cmpField.getFieldName(), newCmpField);
        }
        this.loadGroups.putAll(defaultValues.loadGroups);
        this.eagerLoadGroup = defaultValues.eagerLoadGroup;
        this.readAhead = defaultValues.readAhead;
        this.cleanReadAheadOnLoad = defaultValues.cleanReadAheadOnLoad;
        this.optimisticLocking = defaultValues.optimisticLocking;
        this.audit = defaultValues.audit;
        for (JDBCQueryMetaData query : defaultValues.queries.values()) {
            this.queries.put(query.getMethod(), this.queryFactory.createJDBCQueryMetaData(query, this.readAhead, this.qlCompiler));
        }
        this.cmpConfig = new CmpConfig();
    }

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, ParsedEntity parsed, JDBCEntityMetaData defaultValues) {
        Integer fetchSizeInt;
        this.jdbcApplication = jdbcApplication;
        this.entityName = defaultValues.getName();
        this.entityClass = defaultValues.getEntityClass();
        this.primaryKeyClass = defaultValues.getPrimaryKeyClass();
        this.isCMP1x = defaultValues.isCMP1x;
        this.primaryKeyFieldName = defaultValues.getPrimaryKeyFieldName();
        this.homeClass = defaultValues.getHomeClass();
        this.remoteClass = defaultValues.getRemoteClass();
        this.localHomeClass = defaultValues.getLocalHomeClass();
        this.localClass = defaultValues.getLocalClass();
        this.abstractSchemaName = this.isCMP1x ? (defaultValues.getAbstractSchemaName() == null ? this.entityName : defaultValues.getAbstractSchemaName()) : defaultValues.getAbstractSchemaName();
        this.dataSourceName = parsed.getDataSourceName() != null ? parsed.getDataSourceName() : defaultValues.getDataSourceName();
        this.dataSourceMappingName = parsed.getDataSourceMappingName() != null ? parsed.getDataSourceMappingName() : defaultValues.dataSourceMappingName;
        this.tableName = parsed.getTableName() != null ? parsed.getTableName() : defaultValues.getDefaultTableName();
        this.createTable = parsed.getCreateTable() != null ? parsed.getCreateTable().booleanValue() : defaultValues.getCreateTable();
        this.createTableIfNotExistsSupported = parsed.getCreateTableIfNotExistsSupported() != null ? parsed.getCreateTableIfNotExistsSupported().booleanValue() : defaultValues.getCreateTableIfNotExistsSupported();
        this.removeTable = parsed.getRemoveTable() != null ? parsed.getRemoveTable().booleanValue() : defaultValues.getRemoveTable();
        this.alterTable = parsed.getAlterTable() != null ? parsed.getAlterTable().booleanValue() : defaultValues.getAlterTable();
        if (!parsed.getTablePostCreateCmd().isEmpty()) {
            this.tablePostCreateCmd.addAll(parsed.getTablePostCreateCmd());
        } else {
            this.tablePostCreateCmd.addAll(defaultValues.getDefaultTablePostCreateCmd());
        }
        this.readOnly = parsed.getReadOnly() != null ? parsed.getReadOnly().booleanValue() : defaultValues.isReadOnly();
        this.readTimeOut = parsed.getReadTimeOut() != null ? parsed.getReadTimeOut() : Integer.valueOf(defaultValues.getReadTimeOut());
        this.rowLocking = parsed.getRowLocking() != null ? !this.isReadOnly() && parsed.getRowLocking() != false : defaultValues.hasRowLocking();
        this.primaryKeyConstraint = parsed.getPrimaryKeyConstraint() != null ? parsed.getPrimaryKeyConstraint().booleanValue() : defaultValues.hasPrimaryKeyConstraint();
        Integer listCacheMaxInt = parsed.getListCacheMax();
        if (listCacheMaxInt != null) {
            this.listCacheMax = listCacheMaxInt;
            if (this.listCacheMax < 0) {
                throw CmpMessages.MESSAGES.negativeListCacheMax(this.listCacheMax);
            }
        } else {
            this.listCacheMax = defaultValues.getListCacheMax();
        }
        if ((fetchSizeInt = parsed.getFetchSize()) != null) {
            this.fetchSize = fetchSizeInt;
            if (this.fetchSize < 0) {
                throw CmpMessages.MESSAGES.negativeFetchSize(this.fetchSize);
            }
        } else {
            this.fetchSize = defaultValues.getFetchSize();
        }
        this.qlCompiler = parsed.getQlCompiler() == null ? defaultValues.qlCompiler : parsed.getQlCompiler();
        this.throwRuntimeExceptions = parsed.getThrowRuntimeExceptions() != null ? parsed.getThrowRuntimeExceptions().booleanValue() : defaultValues.getThrowRuntimeExceptions();
        for (JDBCCMPFieldMetaData cmpField : defaultValues.cmpFields) {
            this.cmpFields.add(cmpField);
            this.cmpFieldsByName.put(cmpField.getFieldName(), cmpField);
        }
        for (ParsedCmpField parsedField : parsed.getCmpFields()) {
            String fieldName = parsedField.getFieldName();
            JDBCCMPFieldMetaData oldCMPField = this.cmpFieldsByName.get(fieldName);
            if (oldCMPField == null) {
                throw CmpMessages.MESSAGES.cmpFieldNotFound(fieldName, this.entityName);
            }
            JDBCCMPFieldMetaData cmpFieldMetaData = new JDBCCMPFieldMetaData(this, parsedField, oldCMPField);
            this.cmpFieldsByName.put(fieldName, cmpFieldMetaData);
            int index = this.cmpFields.indexOf(oldCMPField);
            this.cmpFields.remove(oldCMPField);
            this.cmpFields.add(index, cmpFieldMetaData);
        }
        if (this.primaryKeyClass == Object.class && parsed.getUpkField() != null) {
            JDBCCMPFieldMetaData oldUpkField = null;
            for (JDBCCMPFieldMetaData cmpField : this.cmpFields) {
                if (!cmpField.isUnknownPkField()) continue;
                oldUpkField = cmpField;
                break;
            }
            if (oldUpkField == null) {
                oldUpkField = new JDBCCMPFieldMetaData(this);
            }
            JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this, parsed.getUpkField(), oldUpkField);
            this.cmpFieldsByName.remove(oldUpkField.getFieldName());
            this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
            int oldUpkFieldInd = this.cmpFields.indexOf(oldUpkField);
            this.cmpFields.remove(oldUpkField);
            this.cmpFields.add(oldUpkFieldInd, upkField);
        }
        this.loadGroups.putAll(defaultValues.loadGroups);
        this.loadGroups.putAll(parsed.getLoadGroups());
        if (parsed.getEagerLoadGroup() != null) {
            if (!parsed.getEagerLoadGroup().equals("*") && !this.loadGroups.containsKey(parsed.getEagerLoadGroup())) {
                throw CmpMessages.MESSAGES.eagerLoadGroupNotFound(parsed.getEagerLoadGroup());
            }
            this.eagerLoadGroup = parsed.getEagerLoadGroup();
        } else {
            this.eagerLoadGroup = defaultValues.getEagerLoadGroup();
        }
        this.lazyLoadGroups.addAll(defaultValues.lazyLoadGroups);
        this.lazyLoadGroups.addAll(parsed.getLazyLoadGroups());
        this.readAhead = parsed.getReadAhead() != null ? new JDBCReadAheadMetaData(parsed.getReadAhead(), defaultValues.getReadAhead()) : defaultValues.readAhead;
        this.cleanReadAheadOnLoad = parsed.getCleanReadAheadOnLoad() != null ? parsed.getCleanReadAheadOnLoad() : defaultValues.cleanReadAheadOnLoad;
        this.optimisticLocking = parsed.getOptimisticLocking() != null ? new JDBCOptimisticLockingMetaData(this, parsed.getOptimisticLocking()) : defaultValues.getOptimisticLocking();
        this.audit = parsed.getAudit() != null ? new JDBCAuditMetaData(this, parsed.getAudit()) : defaultValues.getAudit();
        for (JDBCQueryMetaData query : defaultValues.queries.values()) {
            query = this.queryFactory.createJDBCQueryMetaData(query, this.readAhead, this.qlCompiler);
            this.queries.put(query.getMethod(), query);
        }
        for (ParsedQuery parsedQuery : parsed.getQueries()) {
            for (JDBCQueryMetaData queryMetaData : this.queryFactory.createJDBCQueryMetaData(parsedQuery)) {
                this.queries.put(queryMetaData.getMethod(), queryMetaData);
            }
        }
        if (parsed.getEntityCommand() != null) {
            String entityCommandName = parsed.getEntityCommand().getCommandName();
            JDBCEntityCommandMetaData defaultEntityCommand = defaultValues.getEntityCommand();
            if (defaultEntityCommand == null || !entityCommandName.equals(defaultEntityCommand.getCommandName())) {
                defaultEntityCommand = jdbcApplication.getEntityCommandByName(entityCommandName);
            }
            this.entityCommand = defaultEntityCommand != null ? new JDBCEntityCommandMetaData(parsed.getEntityCommand(), defaultEntityCommand) : parsed.getEntityCommand();
        } else {
            this.entityCommand = defaultValues.getEntityCommand();
        }
        this.cmpConfig = parsed.getCmpConfig();
    }

    public JDBCApplicationMetaData getJDBCApplication() {
        return this.jdbcApplication;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public JDBCTypeMappingMetaData getTypeMapping() {
        if (this.dataSourceMappingName == null) {
            return null;
        }
        JDBCTypeMappingMetaData typeMapping = this.jdbcApplication.getTypeMappingByName(this.dataSourceMappingName);
        if (typeMapping == null) {
            throw CmpMessages.MESSAGES.typeMappingNotInitialized(this.dataSourceName);
        }
        return typeMapping;
    }

    public String getName() {
        return this.entityName;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Class<?> getHomeClass() {
        return this.homeClass;
    }

    public Class<?> getRemoteClass() {
        return this.remoteClass;
    }

    public Class<?> getLocalHomeClass() {
        return this.localHomeClass;
    }

    public Class<?> getLocalClass() {
        return this.localClass;
    }

    public boolean isCMP1x() {
        return this.isCMP1x;
    }

    public List<JDBCCMPFieldMetaData> getCMPFields() {
        return Collections.unmodifiableList(this.cmpFields);
    }

    public String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    public List<String> getLazyLoadGroups() {
        return Collections.unmodifiableList(this.lazyLoadGroups);
    }

    public Map<String, List<String>> getLoadGroups() {
        return Collections.unmodifiableMap(this.loadGroups);
    }

    public List<String> getLoadGroup(String name) {
        List<String> group = this.loadGroups.get(name);
        if (group == null) {
            throw CmpMessages.MESSAGES.unknownLoadGroup(name);
        }
        return group;
    }

    public JDBCOptimisticLockingMetaData getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public JDBCAuditMetaData getAudit() {
        return this.audit;
    }

    public JDBCCMPFieldMetaData getCMPFieldByName(String name) {
        return this.cmpFieldsByName.get(name);
    }

    public String getDefaultTableName() {
        return this.tableName;
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public boolean getCreateTableIfNotExistsSupported() {
        return this.createTableIfNotExistsSupported;
    }

    public boolean getRemoveTable() {
        return this.removeTable;
    }

    public boolean getAlterTable() {
        return this.alterTable;
    }

    public List<String> getDefaultTablePostCreateCmd() {
        return this.tablePostCreateCmd;
    }

    public boolean hasPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public boolean hasRowLocking() {
        return this.rowLocking;
    }

    public int getListCacheMax() {
        return this.listCacheMax;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Collection<JDBCQueryMetaData> getQueries() {
        return Collections.unmodifiableCollection(this.queries.values());
    }

    public JDBCQueryMetaData getQueryMetaDataForMethod(Method method) {
        return this.queries.get(method);
    }

    public Collection<JDBCRelationshipRoleMetaData> getRelationshipRoles() {
        return this.jdbcApplication.getRolesForEntity(this.entityName);
    }

    public Class<?> getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public JDBCEntityCommandMetaData getEntityCommand() {
        return this.entityCommand;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getReadTimeOut() {
        return this.readTimeOut != null ? this.readTimeOut : -1;
    }

    public String getPrimaryKeyFieldName() {
        return this.primaryKeyFieldName;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Class<?> getQlCompiler() {
        return this.qlCompiler;
    }

    public boolean isThrowRuntimeExceptions() {
        return this.throwRuntimeExceptions;
    }

    public boolean getThrowRuntimeExceptions() {
        return this.throwRuntimeExceptions;
    }

    public boolean isCleanReadAheadOnLoad() {
        return this.cleanReadAheadOnLoad;
    }

    public CmpConfig getCmpConfig() {
        return this.cmpConfig;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCEntityMetaData) {
            JDBCEntityMetaData entity = (JDBCEntityMetaData)o;
            return this.entityName.equals(entity.entityName) && this.jdbcApplication.equals(entity.jdbcApplication);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.jdbcApplication.hashCode();
        result = 37 * result + this.entityName.hashCode();
        return result;
    }

    public String toString() {
        return "[JDBCEntityMetaData : entityName=" + this.entityName + "]";
    }
}

