/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import org.jboss.as.cmp.jdbc.JDBCParameterSetter;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCUtil;

public final class JDBCTypeComplexProperty {
    private final String propertyName;
    private final String columnName;
    private final Class javaType;
    private final int jdbcType;
    private final String sqlType;
    private final boolean notNull;
    private final JDBCResultSetReader resultSetReader;
    private final JDBCParameterSetter paramSetter;
    private final Method[] getters;
    private final Method[] setters;

    public JDBCTypeComplexProperty(String propertyName, String columnName, Class javaType, int jdbcType, String sqlType, boolean notNull, Method[] getters, Method[] setters) {
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.sqlType = sqlType;
        this.notNull = notNull;
        this.getters = getters;
        this.setters = setters;
        this.resultSetReader = JDBCUtil.getResultSetReader(jdbcType, javaType);
        this.paramSetter = JDBCUtil.getParameterSetter(jdbcType, javaType);
    }

    public JDBCTypeComplexProperty(JDBCTypeComplexProperty defaultProperty, String columnName, int jdbcType, String sqlType, boolean notNull) {
        this.propertyName = defaultProperty.propertyName;
        this.columnName = columnName;
        this.javaType = defaultProperty.javaType;
        this.jdbcType = jdbcType;
        this.sqlType = sqlType;
        this.notNull = notNull;
        this.getters = defaultProperty.getters;
        this.setters = defaultProperty.setters;
        this.resultSetReader = JDBCUtil.getResultSetReader(jdbcType, this.javaType);
        this.paramSetter = JDBCUtil.getParameterSetter(jdbcType, this.javaType);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public JDBCResultSetReader getResultSetReader() {
        return this.resultSetReader;
    }

    public JDBCParameterSetter getParameterSetter() {
        return this.paramSetter;
    }

    public Object getColumnValue(Object value) throws Exception {
        Object[] noArgs = new Object[]{};
        for (int i = 0; i < this.getters.length; ++i) {
            if (value == null) {
                return null;
            }
            value = this.getters[i].invoke(value, noArgs);
        }
        return value;
    }

    public Object setColumnValue(Object value, Object columnValue) throws Exception {
        Object[] noArgs = new Object[]{};
        Object[] singleArg = new Object[1];
        Object returnValue = value;
        for (int i = 0; i < this.getters.length - 1; ++i) {
            Object next = this.getters[i].invoke(value, noArgs);
            if (next == null) {
                singleArg[0] = next = this.getters[i].getReturnType().newInstance();
                this.setters[i].invoke(value, singleArg);
            }
            value = next;
        }
        singleArg[0] = columnValue;
        this.setters[this.setters.length - 1].invoke(value, singleArg);
        return returnValue;
    }
}

