/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.rhq.server.metrics.domain.ColumnMetadata;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class RawNumericMetricMapper
implements ResultSetMapper<RawNumericMetric> {
    private ResultSetMapper<RawNumericMetric> mapper;

    public RawNumericMetricMapper() {
        this(false);
    }

    public RawNumericMetricMapper(boolean metaDataIncluded) {
        this.mapper = metaDataIncluded ? new ResultSetMapper<RawNumericMetric>(){

            @Override
            public List<RawNumericMetric> mapAll(ResultSet resultSet) {
                ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
                for (Row row : resultSet) {
                    metrics.add(this.map(row));
                }
                return metrics;
            }

            @Override
            public RawNumericMetric mapOne(ResultSet resultSet) {
                return this.map(resultSet.one());
            }

            @Override
            public List<RawNumericMetric> map(Row ... row) {
                ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
                for (Row singleRow : row) {
                    metrics.add(this.map(singleRow));
                }
                return metrics;
            }

            @Override
            public RawNumericMetric map(Row row) {
                RawNumericMetric metric = new RawNumericMetric(row.getInt(0), row.getDate(1).getTime(), row.getDouble(2));
                ColumnMetadata metadata = new ColumnMetadata(row.getInt(3), row.getLong(4));
                metric.setColumnMetadata(metadata);
                return metric;
            }
        } : new ResultSetMapper<RawNumericMetric>(){

            @Override
            public List<RawNumericMetric> mapAll(ResultSet resultSet) {
                ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
                for (Row row : resultSet) {
                    metrics.add(this.map(row));
                }
                return metrics;
            }

            @Override
            public RawNumericMetric mapOne(ResultSet resultSet) {
                if (resultSet.isExhausted()) {
                    return null;
                }
                return this.map(resultSet.one());
            }

            @Override
            public List<RawNumericMetric> map(Row ... row) {
                ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
                for (Row singleRow : row) {
                    metrics.add(this.map(singleRow));
                }
                return metrics;
            }

            @Override
            public RawNumericMetric map(Row row) {
                return new RawNumericMetric(row.getInt(0), row.getDate(1).getTime(), row.getDouble(2));
            }
        };
    }

    @Override
    public List<RawNumericMetric> mapAll(ResultSet resultSet) {
        return this.mapper.mapAll(resultSet);
    }

    @Override
    public RawNumericMetric mapOne(ResultSet resultSet) {
        return this.mapper.mapOne(resultSet);
    }

    @Override
    public List<RawNumericMetric> map(Row ... row) {
        return this.mapper.map(row);
    }

    @Override
    public RawNumericMetric map(Row row) {
        return this.mapper.map(row);
    }
}

