/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.AsyncFunction;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.rhq.server.metrics.SignalingCountDownLatch;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.AggregationState;
import org.rhq.server.metrics.aggregation.AggregationType;
import org.rhq.server.metrics.aggregation.BatchAggregationScheduler;

class SixHourDataScheduler
extends BatchAggregationScheduler {
    public SixHourDataScheduler(AggregationState state) {
        super(state);
    }

    @Override
    protected SignalingCountDownLatch getAggregationDoneSignal() {
        return this.state.getSixHourAggregationDone();
    }

    @Override
    protected AggregationType getAggregationType() {
        return AggregationType.SIX_HOUR;
    }

    @Override
    protected StorageResultSetFuture findMetricData(int scheduleId) {
        return this.state.getDao().findSixHourMetricsAsync(scheduleId, this.state.getTwentyFourHourTimeSlice().getMillis(), this.state.getTwentyFourHourTimeSliceEnd().getMillis());
    }

    @Override
    protected AsyncFunction<List<ResultSet>, List<ResultSet>> getComputeAggregates() {
        return this.state.getCompute24HourData();
    }

    @Override
    protected AtomicInteger getRemainingSchedules() {
        return this.state.getRemaining6HourData();
    }
}

