/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.server.metrics.SignalingCountDownLatch;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.AggregationState;
import org.rhq.server.metrics.aggregation.AggregationType;
import org.rhq.server.metrics.aggregation.BatchAggregationState;
import org.rhq.server.metrics.aggregation.BatchAggregator;

abstract class BatchAggregationScheduler
implements FutureCallback<ResultSet> {
    private final Log log = LogFactory.getLog(BatchAggregationScheduler.class);
    protected AggregationState state;

    public BatchAggregationScheduler(AggregationState state) {
        this.state = state;
    }

    public void onSuccess(ResultSet indexResultSet) {
        Stopwatch stopwatch = new Stopwatch().start();
        Stopwatch batchStopwatch = new Stopwatch().start();
        ArrayList<StorageResultSetFuture> queryFutures = new ArrayList<StorageResultSetFuture>(this.state.getBatchSize());
        List rows = indexResultSet.all();
        this.getRemainingSchedules().getAndSet(rows.size());
        try {
            for (Row row : rows) {
                this.state.getPermits().acquire();
                queryFutures.add(this.findMetricData(row.getInt(1)));
                if (queryFutures.size() != this.state.getBatchSize()) continue;
                this.state.getAggregationTasks().submit((Runnable)new BatchAggregator(this.createBatchAggregationState(queryFutures, batchStopwatch)));
                queryFutures = new ArrayList(this.state.getBatchSize());
                batchStopwatch = new Stopwatch().start();
            }
            if (!queryFutures.isEmpty()) {
                this.state.getAggregationTasks().submit((Runnable)new BatchAggregator(this.createBatchAggregationState(queryFutures, batchStopwatch)));
            }
            if (rows.isEmpty()) {
                this.getAggregationDoneSignal().countDown();
            }
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished scheduling " + (Object)((Object)this.getAggregationType()) + " aggregation tasks for " + rows.size() + " schedules in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
        catch (InterruptedException e) {
            this.log.info((Object)("There was an interrupt while scheduling aggregation tasks for " + (Object)((Object)this.getAggregationType()) + ": " + e.getMessage()));
            this.log.info((Object)"Aggregation will be aborted");
            this.getAggregationDoneSignal().abort("There was an interrupt while scheduling aggregation tasks for " + (Object)((Object)this.getAggregationType()) + ": " + e.getMessage());
        }
    }

    private BatchAggregationState createBatchAggregationState(List<StorageResultSetFuture> queryFutures, Stopwatch batchStopwatch) {
        return new BatchAggregationState().setAggregationTasks(this.state.getAggregationTasks()).setAggregationType(this.getAggregationType()).setComputeAggregates(this.getComputeAggregates()).setDoneSignal(this.getAggregationDoneSignal()).setPermits(this.state.getPermits()).setQueryFutures(queryFutures).setRemainingSchedules(this.getRemainingSchedules()).setStopwatch(batchStopwatch);
    }

    public void onFailure(Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Aggregation for time slice [" + this.state.getStartTime() + "] cannot proceed. There was an " + "unexpected error while retrieving " + (Object)((Object)this.getAggregationType()) + " index entries."), t);
        } else {
            this.log.warn((Object)("Aggregation for time slice [" + this.state.getStartTime() + "] cannot proceed. There was an " + "unexpected error while retrieving " + (Object)((Object)this.getAggregationType()) + " index entries: " + ThrowableUtil.getRootMessage((Throwable)t)));
        }
        this.getAggregationDoneSignal().abort("There was an error while retrieving " + (Object)((Object)this.getAggregationType()) + " index entries: " + ThrowableUtil.getRootMessage((Throwable)t));
    }

    protected abstract SignalingCountDownLatch getAggregationDoneSignal();

    protected abstract AggregationType getAggregationType();

    protected abstract StorageResultSetFuture findMetricData(int var1);

    protected abstract AsyncFunction<List<ResultSet>, List<ResultSet>> getComputeAggregates();

    protected abstract AtomicInteger getRemainingSchedules();
}

