/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.server.metrics.CQLException;
import org.rhq.server.metrics.QueryCallback;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class Query<T> {
    private PreparedStatement statement;
    private Connection connection;
    private ResultSetMapper<T> resultSetMapper;

    public Query(Connection connection, PreparedStatement statement, ResultSetMapper<T> resultSetMapper) {
        this.connection = connection;
        this.statement = statement;
        this.resultSetMapper = resultSetMapper;
    }

    public void forEach(QueryCallback<T> callback) {
        ResultSet resultSet = null;
        try {
            resultSet = this.statement.executeQuery();
            while (resultSet.next()) {
            }
        }
        catch (SQLException e) {
            throw new CQLException(e);
        }
        finally {
            JDBCUtil.safeClose((ResultSet)resultSet);
            JDBCUtil.safeClose((Statement)this.statement);
            JDBCUtil.safeClose((Connection)this.connection);
        }
    }
}

